/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import java.util.Map;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.type.GenericObjectFactory;
import org.hypergraphdb.type.HGAtomType;
import org.hypergraphdb.type.MapType;

public class MapTypeConstructor
implements HGAtomType {
    private HyperGraph hg;

    @Override
    public void setHyperGraph(HyperGraph hg2) {
        this.hg = hg2;
    }

    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        MapType result = null;
        String className = new String(this.hg.getStore().getData(handle));
        try {
            Class<?> clazz = Class.forName(className);
            GenericObjectFactory<Map<Object, Object>> factory = new GenericObjectFactory<Map<Object, Object>>(clazz);
            result = new MapType(factory);
        }
        catch (Throwable t) {
            throw new HGException(t);
        }
        return result;
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        MapType type = (MapType)instance;
        String className = type.getFactory().getType().getName();
        HGPersistentHandle result = this.hg.getStore().store(className.getBytes());
        return result;
    }

    @Override
    public void release(HGPersistentHandle handle) {
        this.hg.getStore().removeData(handle);
    }

    @Override
    public boolean subsumes(Object general, Object specific) {
        return false;
    }
}

