/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGLink;
import org.hypergraphdb.type.Record;

public class LinkRecord
extends Record
implements HGLink {
    private HGHandle[] targets;

    public LinkRecord(HGHandle type) {
        super(type);
        this.targets = new HGHandle[0];
    }

    public LinkRecord(HGHandle type, HGHandle[] targets) {
        super(type);
        if (targets == null) {
            throw new NullPointerException("Attempt to construct a LinkRecord with a null target set.");
        }
        this.targets = targets;
    }

    @Override
    public int getArity() {
        return this.targets.length;
    }

    @Override
    public HGHandle getTargetAt(int i) {
        return this.targets[i];
    }

    @Override
    public void notifyTargetHandleUpdate(int i, HGHandle handle) {
        this.targets[i] = handle;
    }

    @Override
    public void notifyTargetRemoved(int i) {
        HGHandle[] newOutgoing = new HGHandle[this.targets.length - 1];
        System.arraycopy(this.targets, 0, newOutgoing, 0, i);
        System.arraycopy(this.targets, i + 1, newOutgoing, i, this.targets.length - i - 1);
        this.targets = newOutgoing;
    }
}

