/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGLink;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGQuery;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.type.BonesOfBeans;
import org.hypergraphdb.type.DefaultJavaTypeMapper;
import org.hypergraphdb.type.HGAtomType;
import org.hypergraphdb.type.JavaObjectMapper;
import org.hypergraphdb.type.JavaTypeMapper;
import org.hypergraphdb.type.Slot;
import org.hypergraphdb.util.AccessibleObjectCache;

public class JavaTypeFactory
implements JavaTypeMapper {
    protected HyperGraph graph;
    private static AccessibleObjectCache accessibleObjectCache = new AccessibleObjectCache();
    private ArrayList<JavaTypeMapper> mappers = new ArrayList();
    private JavaObjectMapper objectMapper = null;
    private DefaultJavaTypeMapper defaultMapper = new DefaultJavaTypeMapper();
    static HGHandle superSlot = null;

    public JavaTypeFactory() {
        this.mappers.add(this.defaultMapper);
        this.objectMapper = new JavaObjectMapper();
        this.mappers.add(this.objectMapper);
    }

    void assign(Object bean, String property, Object value) {
        BonesOfBeans.setProperty(bean, property, value);
    }

    public static void assignPrivate(Class<?> clazz, Object x, String field, Object value) {
        Field f = accessibleObjectCache.getField(clazz, field);
        try {
            f.set(x, value);
        }
        catch (IllegalAccessException ex) {
            throw new HGException(ex);
        }
    }

    public static Object retrievePrivate(Class<?> clazz, Object x, String field) {
        Field f = accessibleObjectCache.getField(x.getClass(), field);
        try {
            return f.get(x);
        }
        catch (IllegalAccessException ex) {
            throw new HGException(ex);
        }
    }

    public static boolean isAbstract(Class<?> c) {
        return Modifier.isAbstract(c.getModifiers()) || Modifier.isInterface(c.getModifiers());
    }

    public static Constructor<?> findDefaultConstructor(Class<?> c) {
        for (Constructor<?> con : c.getDeclaredConstructors()) {
            if (con.getParameterTypes().length != 0) continue;
            return con;
        }
        return null;
    }

    public static boolean isDefaultConstructible(Class<?> c) {
        try {
            c.getConstructor(new Class[0]);
            return true;
        }
        catch (NoSuchMethodException ex) {
            return JavaTypeFactory.findDefaultConstructor(c) != null;
        }
    }

    public static Field findDeclaredField(Class<?> c, String name) throws SecurityException {
        try {
            return c.getDeclaredField(name);
        }
        catch (NoSuchFieldException ex) {
            return c.getSuperclass() == null ? null : JavaTypeFactory.findDeclaredField(c.getSuperclass(), name);
        }
    }

    public static Constructor<?> findHandleArgsConstructor(Class<?> c) {
        for (Constructor<?> con : c.getDeclaredConstructors()) {
            if (con.getParameterTypes().length == 0) continue;
            boolean match = true;
            for (Class<?> paramClass : con.getParameterTypes()) {
                if (HGHandle.class.isAssignableFrom(paramClass)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return con;
        }
        return null;
    }

    public static boolean isLink(Class<?> c) {
        boolean b = HGLink.class.isAssignableFrom(c);
        if (!b) {
            return false;
        }
        try {
            c.getDeclaredConstructor(HGHandle[].class);
            return true;
        }
        catch (NoSuchMethodException ex) {
            return JavaTypeFactory.findHandleArgsConstructor(c) != null;
        }
    }

    public static boolean isHGInstantiable(Class<?> c) {
        return !JavaTypeFactory.isAbstract(c) && (JavaTypeFactory.isDefaultConstructible(c) || JavaTypeFactory.isLink(c));
    }

    public static HGHandle getSlotHandle(HyperGraph graph, String label, HGHandle type) {
        HGHandle slotHandle = (HGHandle)HGQuery.hg.findOne(graph, HGQuery.hg.eq(new Slot(label, type)));
        if (slotHandle == null) {
            return graph.add(new Slot(label, type));
        }
        return slotHandle;
    }

    static HGHandle getSuperSlot(HyperGraph graph) {
        if (superSlot == null) {
            superSlot = JavaTypeFactory.getSlotHandle(graph, "!super", graph.getTypeSystem().getTypeHandle(HGPersistentHandle.class));
        }
        return superSlot;
    }

    @Override
    public HGAtomType defineHGType(Class<?> javaClass, HGHandle typeHandle) {
        for (JavaTypeMapper m : this.mappers) {
            HGAtomType t = m.defineHGType(javaClass, typeHandle);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Override
    public HGAtomType getJavaBinding(HGHandle typeHandle, HGAtomType hgType, Class<?> javaClass) {
        for (JavaTypeMapper m : this.mappers) {
            HGAtomType t = m.getJavaBinding(typeHandle, hgType, javaClass);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Override
    public void setHyperGraph(HyperGraph graph) {
        this.graph = graph;
        for (JavaTypeMapper m : this.mappers) {
            m.setHyperGraph(graph);
        }
    }

    public DefaultJavaTypeMapper getDefaultJavaMapper() {
        return this.defaultMapper;
    }

    public JavaObjectMapper getJavaObjectMapper() {
        return this.objectMapper;
    }

    public List<JavaTypeMapper> getMappers() {
        return this.mappers;
    }
}

