/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import java.lang.reflect.Field;
import java.util.HashSet;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGIndex;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGRandomAccessResult;
import org.hypergraphdb.HGTypeSystem;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.annotation.AtomReference;
import org.hypergraphdb.annotation.HGIgnore;
import org.hypergraphdb.atom.AtomProjection;
import org.hypergraphdb.atom.HGAtomRef;
import org.hypergraphdb.atom.HGSerializable;
import org.hypergraphdb.indexing.ByPartIndexer;
import org.hypergraphdb.type.HGAbstractType;
import org.hypergraphdb.type.HGAtomType;
import org.hypergraphdb.type.HGCompositeType;
import org.hypergraphdb.type.JavaAbstractBinding;
import org.hypergraphdb.type.JavaInterfaceBinding;
import org.hypergraphdb.type.JavaObjectBinding;
import org.hypergraphdb.type.JavaTypeFactory;
import org.hypergraphdb.type.JavaTypeMapper;
import org.hypergraphdb.type.RecordType;
import org.hypergraphdb.type.Slot;
import org.hypergraphdb.util.HGUtils;

public class JavaObjectMapper
implements JavaTypeMapper {
    protected HyperGraph graph = null;
    protected HashSet<String> classes = null;
    protected HGHandle superSlot = null;
    protected HGIndex<String, HGPersistentHandle> idx = null;

    protected HGIndex<String, HGPersistentHandle> getIndex() {
        if (this.idx == null) {
            HGHandle t = this.graph.getTypeSystem().getTypeHandle(HGSerializable.class);
            ByPartIndexer indexer = new ByPartIndexer(t, "classname");
            this.idx = this.graph.getIndexManager().getIndex(indexer);
            if (this.idx == null) {
                this.idx = this.graph.getIndexManager().register(indexer);
            }
            return this.idx;
        }
        return this.idx;
    }

    public HGHandle getSuperSlot() {
        return JavaTypeFactory.getSuperSlot(this.graph);
    }

    protected void initClasses() {
        if (this.classes != null) {
            return;
        }
        this.classes = new HashSet();
        HGIndex<String, HGPersistentHandle> idx = this.getIndex();
        HGRandomAccessResult<String> rs = idx.scanKeys();
        try {
            while (rs.hasNext()) {
                this.classes.add((String)rs.next());
            }
        }
        catch (Exception ex) {
            throw new HGException(ex);
        }
        finally {
            HGUtils.closeNoException(rs);
        }
    }

    protected boolean checkClass(Class<?> javaClass) {
        if (!this.classes.contains(javaClass.getName())) {
            Class<?> parent = javaClass.getSuperclass();
            if (parent == null) {
                return false;
            }
            if (this.checkClass(parent)) {
                return true;
            }
            for (Class<?> in : javaClass.getInterfaces()) {
                if (!this.checkClass(in)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean mapAsSerializableObject(Class<?> javaClass) {
        this.initClasses();
        return this.checkClass(javaClass);
    }

    private boolean ignoreField(Field f) {
        int m = f.getModifiers();
        return (m & 0x80) != 0 || (m & 8) != 0 || f.getAnnotation(HGIgnore.class) != null;
    }

    private HGAtomRef.Mode getReferenceMode(Class<?> javaClass, Field field) {
        AtomReference ann = field.getAnnotation(AtomReference.class);
        if (ann == null) {
            return null;
        }
        String s = ann.value();
        if ("hard".equals(s)) {
            return HGAtomRef.Mode.hard;
        }
        if ("symbolic".equals(s)) {
            return HGAtomRef.Mode.symbolic;
        }
        if ("floating".equals(s)) {
            return HGAtomRef.Mode.floating;
        }
        throw new HGException("Wrong annotation value '" + s + "' for field '" + field.getName() + "' of class '" + javaClass.getName() + "', must be one of \"hard\", \"symbolic\" or \"floating\".");
    }

    @Override
    public void setHyperGraph(HyperGraph graph) {
        this.graph = graph;
    }

    @Override
    public HGAtomType defineHGType(Class<?> javaClass, HGHandle typeHandle) {
        if (!this.mapAsSerializableObject(javaClass)) {
            return null;
        }
        HGTypeSystem typeSystem = this.graph.getTypeSystem();
        Field[] fields = javaClass.getDeclaredFields();
        RecordType recType = new RecordType();
        if (javaClass.getSuperclass() != null) {
            boolean has_parent = false;
            HGHandle parentTypeHandle = typeSystem.getTypeHandle(javaClass.getSuperclass());
            Object x = this.graph.get(parentTypeHandle);
            if (x instanceof Class) {
                Class clazz = (Class)x;
                for (Field pf : clazz.getDeclaredFields()) {
                    if (this.ignoreField(pf)) continue;
                    has_parent = true;
                    break;
                }
            } else {
                Object parentType = typeSystem.getAtomType(javaClass.getSuperclass());
                boolean bl = has_parent = parentType instanceof HGCompositeType && ((HGCompositeType)parentType).getDimensionNames().hasNext();
            }
            if (has_parent) {
                recType.addSlot(this.getSuperSlot());
            }
        }
        for (Field field : fields) {
            if (this.ignoreField(field)) continue;
            HGHandle fieldTypeHandle = typeSystem.getTypeHandle(field.getType());
            if (fieldTypeHandle == null) {
                throw new HGException("Unable to create HG type for field " + field.getName() + " of class " + javaClass.getName());
            }
            HGHandle slotHandle = JavaTypeFactory.getSlotHandle(this.graph, field.getName(), fieldTypeHandle);
            Slot slot = (Slot)this.graph.get(slotHandle);
            recType.addSlot(slotHandle);
            HGAtomRef.Mode refMode = this.getReferenceMode(javaClass, field);
            if (refMode == null) continue;
            typeSystem.getHyperGraph().add(new AtomProjection(typeHandle, slot.getLabel(), slot.getValueType(), refMode));
        }
        if (recType.getSlots().isEmpty()) {
            return new HGAbstractType();
        }
        return recType;
    }

    @Override
    public HGAtomType getJavaBinding(HGHandle typeHandle, HGAtomType hgType, Class<?> javaClass) {
        if (this.mapAsSerializableObject(javaClass)) {
            if (hgType instanceof RecordType) {
                RecordType recType = (RecordType)hgType;
                recType.setThisHandle(typeHandle);
                if (JavaTypeFactory.isHGInstantiable(javaClass)) {
                    return new JavaObjectBinding(typeHandle, recType, javaClass);
                }
                return new JavaAbstractBinding(typeHandle, recType, javaClass);
            }
            if (hgType instanceof HGCompositeType) {
                return new JavaAbstractBinding(typeHandle, (HGCompositeType)hgType, javaClass);
            }
            if (hgType instanceof HGAbstractType) {
                return new JavaInterfaceBinding(typeHandle, hgType, javaClass);
            }
            return hgType;
        }
        return null;
    }

    public void addClass(Class<?> c) {
        this.addClass(c.getName());
    }

    public void addClass(String classname) {
        this.initClasses();
        try {
            Class<?> c = Class.forName(classname);
            for (String existing : this.classes) {
                Class<?> e = null;
                try {
                    e = Class.forName(existing);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (e == null || !e.isAssignableFrom(c)) continue;
                return;
            }
            this.graph.add(new HGSerializable(classname));
            this.classes.add(classname);
        }
        catch (Exception ex) {
            throw new HGException(ex);
        }
    }
}

