/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import java.lang.reflect.Constructor;
import java.util.Stack;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.atom.HGAtomRef;
import org.hypergraphdb.type.HGAbstractType;
import org.hypergraphdb.type.HGAtomType;
import org.hypergraphdb.type.JavaAbstractBinding;
import org.hypergraphdb.type.JavaTypeFactory;
import org.hypergraphdb.type.Record;
import org.hypergraphdb.type.RecordType;
import org.hypergraphdb.type.Slot;
import org.hypergraphdb.type.TypeUtils;
import org.hypergraphdb.util.Pair;

public class JavaObjectBinding
extends JavaAbstractBinding {
    private Constructor<?> linkConstructor = null;

    public JavaObjectBinding(HGHandle typeHandle, RecordType hgType, Class<?> clazz) {
        super(typeHandle, hgType, clazz);
        try {
            this.linkConstructor = this.javaClass.getDeclaredConstructor(HGHandle[].class);
        }
        catch (NoSuchMethodException ex) {
            // empty catch block
        }
    }

    private void assignFields(HGPersistentHandle valueHandle, Object instance) {
        HGHandle superSlot = JavaTypeFactory.getSuperSlot(this.graph);
        RecordType hgType = (RecordType)this.hgType;
        Class clazz = this.javaClass;
        while (true) {
            Record record = (Record)hgType.make(valueHandle, null, null);
            HGPersistentHandle ss = null;
            for (HGHandle slotHandle : hgType.getSlots()) {
                Slot slot = (Slot)this.graph.get(slotHandle);
                if (slotHandle.equals(superSlot)) {
                    ss = (HGPersistentHandle)record.get(slot);
                    continue;
                }
                Object value = record.get(slot);
                if (value != null && hgType.getReferenceMode(slotHandle) != null) {
                    value = this.graph.get(((HGAtomRef)value).getReferent());
                }
                JavaTypeFactory.assignPrivate(clazz, instance, slot.getLabel(), value);
            }
            if (ss == null) break;
            clazz = clazz.getSuperclass();
            JavaAbstractBinding superType = (JavaAbstractBinding)this.graph.getTypeSystem().getAtomType(clazz);
            hgType = (RecordType)superType.getHGType();
            valueHandle = ss;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        Object result = null;
        try {
            if (targetSet != null && targetSet.deref().length > 0) {
                if (this.linkConstructor == null) throw new RuntimeException("Can't construct link with Java type " + this.javaClass.getName() + " please include a (HGHandle [] ) constructor.");
                result = this.linkConstructor.newInstance(new Object[]{targetSet.deref()});
            } else {
                result = this.javaClass.newInstance();
            }
            TypeUtils.setValueFor(this.graph, handle, result);
            this.assignFields(handle, result);
            return result;
        }
        catch (InstantiationException ex) {
            throw new HGException("Unable to instantiate bean of type '" + this.javaClass.getName() + "', make sure that bean has a default constructor declared.");
        }
        catch (Throwable t) {
            throw new HGException("JavaTypeBinding.make: " + t.toString(), t);
        }
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        HGPersistentHandle result = TypeUtils.getHandleFor(this.graph, instance);
        if (result == null) {
            HGHandle superSlotHandle = JavaTypeFactory.getSuperSlot(this.graph);
            Slot superSlot = (Slot)this.graph.get(superSlotHandle);
            Class clazz = this.javaClass;
            RecordType recordType = (RecordType)this.hgType;
            Record record = new BeanRecord(this.typeHandle, instance);
            Stack<Pair<RecordType, BeanRecord>> superList = new Stack<Pair<RecordType, BeanRecord>>();
            while (true) {
                superList.push(new Pair<RecordType, BeanRecord>(recordType, (BeanRecord)record));
                boolean has_super = false;
                for (HGHandle slotHandle : recordType.getSlots()) {
                    if (slotHandle.equals(superSlotHandle)) {
                        has_super = true;
                        continue;
                    }
                    Slot slot = (Slot)this.graph.get(slotHandle);
                    Object value = JavaTypeFactory.retrievePrivate(clazz, instance, slot.getLabel());
                    HGAtomRef.Mode refMode = recordType.getReferenceMode(slotHandle);
                    if (refMode != null && value != null) {
                        HGHandle valueAtomHandle = this.graph.getHandle(value);
                        if (valueAtomHandle == null) {
                            HGAtomType valueType = (HGAtomType)this.graph.get(slot.getValueType());
                            valueAtomHandle = this.graph.getPersistentHandle(this.graph.add(value, valueType instanceof HGAbstractType ? this.graph.getTypeSystem().getTypeHandle(value.getClass()) : slot.getValueType()));
                        }
                        value = new HGAtomRef(valueAtomHandle, refMode);
                    }
                    record.set(slot, value);
                }
                if (!has_super) break;
                clazz = clazz.getSuperclass();
                HGHandle superTypeHandle = this.graph.getTypeSystem().getTypeHandle(clazz);
                JavaAbstractBinding superType = (JavaAbstractBinding)this.graph.get(superTypeHandle);
                recordType = (RecordType)superType.getHGType();
                record = new Record(superTypeHandle);
            }
            while (!superList.isEmpty()) {
                Pair curr = (Pair)superList.pop();
                if (result != null) {
                    ((Record)curr.getSecond()).set(superSlot, result);
                }
                result = ((RecordType)curr.getFirst()).store(curr.getSecond());
            }
        }
        return result;
    }

    @Override
    public void release(HGPersistentHandle handle) {
        Record rec = (Record)this.hgType.make(handle, null, null);
        HGPersistentHandle parent = (HGPersistentHandle)rec.get(new Slot("!super", this.graph.getTypeSystem().getTypeHandle(HGPersistentHandle.class)));
        if (parent != null) {
            Object superType = this.graph.getTypeSystem().getAtomType(this.javaClass.getSuperclass());
            superType.release(parent);
        }
        this.hgType.release(handle);
    }

    static class BeanRecord
    extends Record
    implements TypeUtils.WrappedRuntimeInstance {
        Object bean;

        BeanRecord(HGHandle h, Object bean) {
            super(h);
            this.bean = bean;
        }

        @Override
        public Object getRealInstance() {
            return this.bean;
        }
    }
}

