/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import java.lang.reflect.Constructor;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGLink;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.atom.HGAtomRef;
import org.hypergraphdb.type.BonesOfBeans;
import org.hypergraphdb.type.HGAbstractType;
import org.hypergraphdb.type.HGAtomType;
import org.hypergraphdb.type.JavaAbstractBinding;
import org.hypergraphdb.type.JavaTypeFactory;
import org.hypergraphdb.type.Record;
import org.hypergraphdb.type.RecordType;
import org.hypergraphdb.type.Slot;
import org.hypergraphdb.type.TypeUtils;

public class JavaBeanBinding
extends JavaAbstractBinding {
    private Constructor<?> defaultConstructor;
    private Constructor<?> linkConstructor;
    private Constructor<?> handleListConstructor;
    private boolean isLinkInstance;

    public JavaBeanBinding(HGHandle typeHandle, RecordType hgType, Class<?> clazz) {
        block4: {
            super(typeHandle, hgType, clazz);
            this.defaultConstructor = null;
            this.linkConstructor = null;
            this.handleListConstructor = null;
            this.defaultConstructor = JavaTypeFactory.findDefaultConstructor(this.javaClass);
            if (this.defaultConstructor != null) {
                this.defaultConstructor.setAccessible(true);
            }
            try {
                this.linkConstructor = this.javaClass.getDeclaredConstructor(HGHandle[].class);
                if (this.linkConstructor != null) {
                    this.linkConstructor.setAccessible(true);
                }
            }
            catch (NoSuchMethodException ex) {
                this.handleListConstructor = JavaTypeFactory.findHandleArgsConstructor(this.javaClass);
                if (this.handleListConstructor == null) break block4;
                this.handleListConstructor.setAccessible(true);
            }
        }
        this.isLinkInstance = HGLink.class.isAssignableFrom(this.javaClass);
    }

    private HGLink makeLink(HGHandle[] targetSet) throws Exception {
        if (this.linkConstructor != null) {
            return (HGLink)this.linkConstructor.newInstance(new Object[]{targetSet});
        }
        if (this.handleListConstructor != null) {
            return (HGLink)this.handleListConstructor.newInstance(targetSet);
        }
        throw new RuntimeException("Can't construct link with Java type " + this.javaClass.getName() + " please include a (HGHandle [] ) " + " or a (HGHandle, HGHandle, ..., HGHandle) constructor.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        HGLink bean = null;
        try {
            if (this.isLinkInstance && targetSet != null && targetSet.deref().length > 0 || this.defaultConstructor == null) {
                bean = this.makeLink(targetSet.deref());
            } else {
                if (this.defaultConstructor == null) throw new RuntimeException("Can't construct object of type " + this.javaClass.getName() + " no default constructor and/or no HGHandle array-based constructor.");
                bean = this.defaultConstructor.newInstance(new Object[0]);
            }
            TypeUtils.setValueFor(this.graph, handle, bean);
            Record record = (Record)this.hgType.make(handle, targetSet, null);
            RecordType recordType = (RecordType)this.hgType;
            for (HGHandle slotHandle : recordType.getSlots()) {
                Slot slot = (Slot)this.graph.get(slotHandle);
                Object value = record.get(slot);
                if (value != null && recordType.getReferenceMode(slotHandle) != null) {
                    value = this.graph.get(((HGAtomRef)value).getReferent());
                }
                try {
                    BonesOfBeans.setProperty((Object)bean, slot.getLabel(), value);
                }
                catch (Throwable t) {
                    throw new HGException("Failed to assign property: " + slot.getLabel() + " to bean " + bean.getClass(), t);
                    return bean;
                }
            }
        }
        catch (InstantiationException ex) {
            throw new HGException("Unable to instantiate bean of type '" + this.javaClass.getName() + "', make sure that bean has a default constructor declared.", ex);
        }
        catch (HGException t) {
            throw t;
        }
        catch (Throwable t) {
            throw new HGException("JavaTypeBinding.make: " + t.toString(), t);
        }
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        HGPersistentHandle result = TypeUtils.getHandleFor(this.graph, instance);
        if (result == null) {
            BeanRecord record = new BeanRecord(this.typeHandle, instance);
            RecordType recordType = (RecordType)this.hgType;
            for (HGHandle slotHandle : recordType.getSlots()) {
                Slot slot = (Slot)this.graph.get(slotHandle);
                Object value = BonesOfBeans.getProperty(instance, slot.getLabel());
                HGAtomRef.Mode refMode = recordType.getReferenceMode(slotHandle);
                if (refMode != null && value != null) {
                    HGHandle valueAtomHandle = this.graph.getHandle(value);
                    if (valueAtomHandle == null) {
                        HGAtomType valueType = (HGAtomType)this.graph.get(slot.getValueType());
                        valueAtomHandle = this.graph.getPersistentHandle(this.graph.add(value, valueType instanceof HGAbstractType ? this.graph.getTypeSystem().getTypeHandle(value.getClass()) : slot.getValueType()));
                    }
                    value = new HGAtomRef(valueAtomHandle, refMode);
                }
                record.set(slot, value);
            }
            result = this.hgType.store(record);
        }
        return result;
    }

    @Override
    public void release(HGPersistentHandle handle) {
        this.hgType.release(handle);
    }

    static class BeanRecord
    extends Record
    implements TypeUtils.WrappedRuntimeInstance {
        Object bean;

        BeanRecord(HGHandle h, Object bean) {
            super(h);
            this.bean = bean;
        }

        @Override
        public Object getRealInstance() {
            return this.bean;
        }
    }
}

