/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import java.lang.reflect.Constructor;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.type.ObjectFactory;

public class GenericObjectFactory<T>
implements ObjectFactory<T> {
    private Class<T> type;
    private Constructor<T> linkConstructor = null;

    public GenericObjectFactory(Class<T> type) {
        this.type = type;
        try {
            this.linkConstructor = type.getDeclaredConstructor(HGHandle[].class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public T make() {
        try {
            return this.type.newInstance();
        }
        catch (Throwable t) {
            throw new HGException(t);
        }
    }

    @Override
    public T make(HGHandle[] targetSet) {
        if (this.linkConstructor == null) {
            throw new HGException("Unable to construct a link of type " + this.type.getName() + ", the class doesn't have a HGHandle [] based constructor.");
        }
        try {
            return this.linkConstructor.newInstance(new Object[]{targetSet});
        }
        catch (Throwable t) {
            throw new HGException(t);
        }
    }
}

