/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGGraphHolder;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGHandleHolder;
import org.hypergraphdb.HGTypeHolder;
import org.hypergraphdb.HGTypeSystem;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.annotation.AtomReference;
import org.hypergraphdb.annotation.HGIgnore;
import org.hypergraphdb.atom.AtomProjection;
import org.hypergraphdb.atom.HGAtomRef;
import org.hypergraphdb.type.ArrayType;
import org.hypergraphdb.type.BonesOfBeans;
import org.hypergraphdb.type.CollectionType;
import org.hypergraphdb.type.GenericObjectFactory;
import org.hypergraphdb.type.HGAbstractCompositeType;
import org.hypergraphdb.type.HGAbstractType;
import org.hypergraphdb.type.HGAtomType;
import org.hypergraphdb.type.HGCompositeType;
import org.hypergraphdb.type.JavaAbstractBinding;
import org.hypergraphdb.type.JavaBeanBinding;
import org.hypergraphdb.type.JavaInterfaceBinding;
import org.hypergraphdb.type.JavaTypeFactory;
import org.hypergraphdb.type.JavaTypeMapper;
import org.hypergraphdb.type.MapType;
import org.hypergraphdb.type.RecordType;
import org.hypergraphdb.type.Slot;
import org.hypergraphdb.type.javaprimitive.EnumType;

public class DefaultJavaTypeMapper
implements JavaTypeMapper {
    private HyperGraph graph;

    private HGAtomType defineComposite(HGTypeSystem typeSystem, Map<String, PropertyDescriptor> propertiesMap) {
        HGAbstractCompositeType compositeType = new HGAbstractCompositeType();
        for (PropertyDescriptor desc : propertiesMap.values()) {
            HGHandle propTypeHandle;
            if (desc.getReadMethod() == null || desc.getWriteMethod() == null) continue;
            Class<?> propType = desc.getPropertyType();
            if (propType.isPrimitive()) {
                propType = BonesOfBeans.wrapperEquivalentOf(propType);
            }
            if ((propTypeHandle = typeSystem.getTypeHandle(propType)) == null) {
                throw new HGException("Unable to get HyperGraph type for Java class " + propType.getName() + ": make sure it's default or 'link' constructible.");
            }
            compositeType.addProjection(new HGAbstractCompositeType.Projection(desc.getName(), propTypeHandle));
        }
        return compositeType;
    }

    private HGAtomRef.Mode getReferenceMode(Class<?> javaClass, PropertyDescriptor desc) {
        try {
            Field field = javaClass.getDeclaredField(desc.getName());
            AtomReference ann = field.getAnnotation(AtomReference.class);
            if (ann == null) {
                return null;
            }
            String s = ann.value();
            if ("hard".equals(s)) {
                return HGAtomRef.Mode.hard;
            }
            if ("symbolic".equals(s)) {
                return HGAtomRef.Mode.symbolic;
            }
            if ("floating".equals(s)) {
                return HGAtomRef.Mode.floating;
            }
            throw new HGException("Wrong annotation value '" + s + "' for field '" + field.getName() + "' of class '" + javaClass.getName() + "', must be one of \"hard\", \"symbolic\" or \"floating\".");
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
    }

    public static boolean includeProperty(Class<?> javaClass, PropertyDescriptor desc) {
        Method reader = desc.getReadMethod();
        Method writer = desc.getWriteMethod();
        if (reader == null || writer == null) {
            return false;
        }
        if (reader.getAnnotation(HGIgnore.class) != null || writer.getAnnotation(HGIgnore.class) != null) {
            return false;
        }
        if (desc.getName().equals("atomHandle") && HGHandleHolder.class.isAssignableFrom(javaClass)) {
            return false;
        }
        if (desc.getName().equals("atomType") && HGTypeHolder.class.isAssignableFrom(javaClass)) {
            return false;
        }
        if (desc.getName().equals("hyperGraph") && HGGraphHolder.class.isAssignableFrom(javaClass)) {
            return false;
        }
        Field field = JavaTypeFactory.findDeclaredField(javaClass, desc.getName());
        return field == null || field.getAnnotation(HGIgnore.class) == null && (field.getModifiers() & 0x80) == 0;
    }

    @Override
    public HGAtomType defineHGType(Class<?> javaClass, HGHandle typeHandle) {
        HGTypeSystem typeSystem = this.graph.getTypeSystem();
        if (javaClass == null) {
            throw new NullPointerException("JavaTypeFactory.getHGType: null beanClass parameter.");
        }
        if (javaClass.isEnum()) {
            return new EnumType(javaClass);
        }
        if (javaClass.isArray()) {
            return new ArrayType(javaClass.getComponentType());
        }
        Map<String, PropertyDescriptor> descriptors = BonesOfBeans.getAllPropertyDescriptors(javaClass);
        boolean is_record = false;
        for (PropertyDescriptor d : descriptors.values()) {
            if (d.getReadMethod() == null || d.getWriteMethod() == null || !DefaultJavaTypeMapper.includeProperty(javaClass, d)) continue;
            is_record = true;
            break;
        }
        boolean is_abstract = JavaTypeFactory.isAbstract(javaClass);
        boolean is_default_constructible = JavaTypeFactory.isDefaultConstructible(javaClass);
        boolean is_link = JavaTypeFactory.isLink(javaClass);
        boolean is_serializable = Serializable.class.isAssignableFrom(javaClass);
        boolean bl = is_record = is_record && (is_default_constructible || is_link);
        if (is_abstract) {
            if (!is_record) {
                return new HGAbstractType();
            }
            return this.defineComposite(typeSystem, descriptors);
        }
        if (Map.class.isAssignableFrom(javaClass) && is_default_constructible) {
            return new MapType(new GenericObjectFactory<Enum>(javaClass));
        }
        if (Collection.class.isAssignableFrom(javaClass) && is_default_constructible) {
            return new CollectionType(new GenericObjectFactory<Enum>(javaClass));
        }
        if (is_record) {
            RecordType recordType = new RecordType();
            for (PropertyDescriptor desc : descriptors.values()) {
                HGHandle valueTypeHandle;
                if (!DefaultJavaTypeMapper.includeProperty(javaClass, desc)) continue;
                Class<?> propType = desc.getPropertyType();
                if (propType.isPrimitive()) {
                    propType = BonesOfBeans.wrapperEquivalentOf(propType);
                }
                if ((valueTypeHandle = typeSystem.getTypeHandle(propType)) == null) {
                    throw new HGException("Unable to get HyperGraph type for Java class " + propType.getName() + ": make sure it's default or 'link' constructible.");
                }
                HGHandle slotHandle = JavaTypeFactory.getSlotHandle(this.graph, desc.getName(), valueTypeHandle);
                Slot slot = (Slot)this.graph.get(slotHandle);
                recordType.addSlot(slotHandle);
                HGAtomRef.Mode refMode = this.getReferenceMode(javaClass, desc);
                if (refMode == null) continue;
                typeSystem.getHyperGraph().add(new AtomProjection(typeHandle, slot.getLabel(), slot.getValueType(), refMode));
            }
            return recordType;
        }
        if (is_serializable) {
            return typeSystem.getAtomType(Serializable.class);
        }
        if (is_default_constructible || is_link) {
            return new RecordType();
        }
        return null;
    }

    @Override
    public HGAtomType getJavaBinding(HGHandle typeHandle, HGAtomType hgType, Class<?> javaClass) {
        if (hgType instanceof RecordType) {
            RecordType recType = (RecordType)hgType;
            recType.setThisHandle(typeHandle);
            return new JavaBeanBinding(typeHandle, recType, javaClass);
        }
        if (hgType instanceof HGAbstractCompositeType) {
            return new JavaAbstractBinding(typeHandle, (HGCompositeType)hgType, javaClass);
        }
        if (hgType instanceof HGAbstractType) {
            return new JavaInterfaceBinding(typeHandle, hgType, javaClass);
        }
        return hgType;
    }

    @Override
    public void setHyperGraph(HyperGraph graph) {
        this.graph = graph;
    }
}

