/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import java.util.Collection;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.type.CollectionType;
import org.hypergraphdb.type.GenericObjectFactory;
import org.hypergraphdb.type.HGAtomType;

public class CollectionTypeConstructor
implements HGAtomType {
    private HyperGraph graph;

    @Override
    public void setHyperGraph(HyperGraph hg2) {
        this.graph = hg2;
    }

    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        CollectionType result = null;
        String className = new String(this.graph.getStore().getData(handle));
        try {
            Class<?> clazz = Class.forName(className);
            GenericObjectFactory<Collection<Object>> factory = new GenericObjectFactory<Collection<Object>>(clazz);
            result = new CollectionType(factory);
        }
        catch (Throwable t) {
            throw new HGException(t);
        }
        return result;
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        CollectionType type = (CollectionType)instance;
        String className = type.getFactory().getType().getName();
        HGPersistentHandle result = this.graph.getStore().store(className.getBytes());
        return result;
    }

    @Override
    public void release(HGPersistentHandle handle) {
        this.graph.getStore().removeData(handle);
    }

    @Override
    public boolean subsumes(Object general, Object specific) {
        return false;
    }
}

