/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGIndex;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HGSearchable;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.atom.HGAtomRef;
import org.hypergraphdb.event.HGAtomRemoveRequestEvent;
import org.hypergraphdb.event.HGEvent;
import org.hypergraphdb.event.HGListener;
import org.hypergraphdb.query.impl.UnionResult;
import org.hypergraphdb.storage.BAUtils;
import org.hypergraphdb.storage.BAtoHandle;
import org.hypergraphdb.storage.ByteArrayConverter;
import org.hypergraphdb.type.HGAtomType;

public class AtomRefType
implements HGAtomType,
HGSearchable<HGPersistentHandle, HGPersistentHandle>,
ByteArrayConverter<Object> {
    private static final String IDX_HARD_DB_NAME = "hg_atomrefs_hard_idx";
    private static final String IDX_SYMBOLIC_DB_NAME = "hg_atomrefs_symbolic_idx";
    private static final String IDX_FLOATING_DB_NAME = "hg_atomrefs_floating_idx";
    private static final int MODE_OFFSET = 0;
    private static final int REFCOUNT_OFFSET = 1;
    private static final int ATOM_HANDLE_OFFSET = 5;
    private HyperGraph graph;
    private HGIndex<HGPersistentHandle, HGPersistentHandle> hardIdx = null;
    private HGIndex<HGPersistentHandle, HGPersistentHandle> symbolicIdx = null;
    private HGIndex<HGPersistentHandle, HGPersistentHandle> floatingIdx = null;
    private RemovalListener removalListener = new RemovalListener();

    private HGIndex<HGPersistentHandle, HGPersistentHandle> getHardIdx() {
        if (this.hardIdx == null) {
            this.hardIdx = this.graph.getStore().getIndex(IDX_HARD_DB_NAME, BAtoHandle.getInstance(this.graph.getHandleFactory()), BAtoHandle.getInstance(this.graph.getHandleFactory()), null, true);
        }
        return this.hardIdx;
    }

    private HGIndex<HGPersistentHandle, HGPersistentHandle> getSymbolicIdx() {
        if (this.symbolicIdx == null) {
            this.symbolicIdx = this.graph.getStore().getIndex(IDX_SYMBOLIC_DB_NAME, BAtoHandle.getInstance(this.graph.getHandleFactory()), BAtoHandle.getInstance(this.graph.getHandleFactory()), null, true);
        }
        return this.symbolicIdx;
    }

    private HGIndex<HGPersistentHandle, HGPersistentHandle> getFloatingIdx() {
        if (this.floatingIdx == null) {
            this.floatingIdx = this.graph.getStore().getIndex(IDX_FLOATING_DB_NAME, BAtoHandle.getInstance(this.graph.getHandleFactory()), BAtoHandle.getInstance(this.graph.getHandleFactory()), null, true);
        }
        return this.floatingIdx;
    }

    @Override
    public void setHyperGraph(HyperGraph hg2) {
        if (this.graph != null) {
            this.graph.getEventManager().removeListener(HGAtomRemoveRequestEvent.class, this.removalListener);
        }
        this.graph = hg2;
        hg2.getEventManager().addListener(HGAtomRemoveRequestEvent.class, this.removalListener);
    }

    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        byte[] data = this.graph.getStore().getData(handle);
        HGAtomRef.Mode mode = HGAtomRef.Mode.get(data[0]);
        HGPersistentHandle atomHandle = this.graph.getHandleFactory().makeHandle(data, 5);
        return new HGAtomRef(atomHandle, mode);
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        HGIndex<HGPersistentHandle, HGPersistentHandle> idx;
        HGAtomRef ref = (HGAtomRef)instance;
        HGPersistentHandle refHandle = this.graph.getPersistentHandle(ref.getReferent());
        switch (ref.getMode()) {
            case hard: {
                idx = this.getHardIdx();
                break;
            }
            case symbolic: {
                idx = this.getSymbolicIdx();
                break;
            }
            case floating: {
                idx = this.getFloatingIdx();
                break;
            }
            default: {
                idx = null;
            }
        }
        HGPersistentHandle valueHandle = idx.findFirst(refHandle);
        int handleSize = refHandle.toByteArray().length;
        if (valueHandle == null) {
            byte[] data = new byte[5 + handleSize];
            data[0] = ref.getMode().getCode();
            System.arraycopy(refHandle.toByteArray(), 0, data, 5, handleSize);
            BAUtils.writeInt(1, data, 1);
            valueHandle = this.graph.getStore().store(data);
            idx.addEntry(refHandle, valueHandle);
        } else {
            byte[] data = this.graph.getStore().getData(valueHandle);
            BAUtils.writeInt(BAUtils.readInt(data, 1) + 1, data, 1);
            this.graph.getStore().store(valueHandle, data);
        }
        return valueHandle;
    }

    @Override
    public void release(HGPersistentHandle handle) {
        byte[] data = this.graph.getStore().getData(handle);
        HGAtomRef.Mode mode = HGAtomRef.Mode.get(data[0]);
        int count = BAUtils.readInt(data, 1) - 1;
        if (count == 0) {
            boolean makeManaged = false;
            boolean removeRef = false;
            HGPersistentHandle otherRef = null;
            HGPersistentHandle refHandle = this.graph.getHandleFactory().makeHandle(data, 5);
            switch (mode) {
                case hard: {
                    otherRef = this.getFloatingIdx().findFirst(refHandle);
                    if (otherRef != null) {
                        makeManaged = true;
                        removeRef = BAUtils.readInt(this.graph.getStore().getData(otherRef), 1) == 0;
                    } else {
                        removeRef = true;
                    }
                    this.getHardIdx().removeAllEntries(refHandle);
                    break;
                }
                case symbolic: {
                    this.graph.getStore().removeData(handle);
                    this.getSymbolicIdx().removeAllEntries(refHandle);
                    break;
                }
                case floating: {
                    makeManaged = true;
                    otherRef = this.getHardIdx().findFirst(refHandle);
                    removeRef = otherRef == null || BAUtils.readInt(this.graph.getStore().getData(otherRef), 1) == 0;
                    this.getFloatingIdx().removeAllEntries(refHandle);
                }
            }
            if (removeRef) {
                this.graph.getStore().removeData(handle);
                if (otherRef != null) {
                    this.graph.getStore().removeData(otherRef);
                }
                if (makeManaged) {
                    int flags = this.graph.getSystemFlags(refHandle);
                    if ((flags & 2) == 0) {
                        this.graph.setSystemFlags(refHandle, flags | 2);
                    }
                } else {
                    this.graph.remove(refHandle);
                }
            }
        } else {
            BAUtils.writeInt(count, data, 1);
            this.graph.getStore().store(handle, data);
        }
    }

    @Override
    public boolean subsumes(Object general, Object specific) {
        return ((HGAtomRef)general).getReferent().equals(((HGAtomRef)specific).getReferent());
    }

    @Override
    public HGSearchResult<HGPersistentHandle> find(HGPersistentHandle key) {
        if (key instanceof HGAtomRef) {
            HGAtomRef ref = (HGAtomRef)((Object)key);
            HGPersistentHandle pHandle = this.graph.getPersistentHandle(ref.getReferent());
            switch (ref.getMode()) {
                case hard: {
                    return this.getHardIdx().find(pHandle);
                }
                case symbolic: {
                    return this.getSymbolicIdx().find(pHandle);
                }
                case floating: {
                    return this.getFloatingIdx().find(pHandle);
                }
            }
        }
        HGPersistentHandle referent = this.graph.getPersistentHandle(key);
        return new UnionResult(this.getHardIdx().find(referent), new UnionResult(this.getSymbolicIdx().find(referent), this.getFloatingIdx().find(referent)));
    }

    @Override
    public Object fromByteArray(byte[] byteArray) {
        HGPersistentHandle h = BAtoHandle.getInstance(this.graph.getHandleFactory()).fromByteArray(byteArray);
        if (h.equals(this.graph.getHandleFactory().nullHandle())) {
            return null;
        }
        return this.graph.get(h);
    }

    @Override
    public byte[] toByteArray(Object object) {
        if (object == null) {
            return this.graph.getHandleFactory().nullHandle().toByteArray();
        }
        return this.graph.getPersistentHandle(this.graph.getHandle(object)).toByteArray();
    }

    private class RemovalListener
    implements HGListener {
        private RemovalListener() {
        }

        @Override
        public HGListener.Result handle(HyperGraph hg2, HGEvent event) {
            HGAtomRemoveRequestEvent ev = (HGAtomRemoveRequestEvent)event;
            HGPersistentHandle pHandle = hg2.getPersistentHandle(ev.getAtomHandle());
            if (AtomRefType.this.getHardIdx().findFirst(pHandle) != null || AtomRefType.this.getFloatingIdx().findFirst(pHandle) != null) {
                return HGListener.Result.cancel;
            }
            return HGListener.Result.ok;
        }
    }
}

