/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.type.HGAtomType;
import org.hypergraphdb.type.TypeUtils;

public class ArrayType
implements HGAtomType {
    private HyperGraph graph = null;
    private Constructor<?> linkConstructor = null;
    private Class<?> clazz;

    public ArrayType(Class<?> clazz) {
        this.clazz = clazz;
        try {
            this.linkConstructor = clazz.getDeclaredConstructor(HGHandle[].class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public Class<?> getType() {
        return this.clazz;
    }

    @Override
    public void setHyperGraph(HyperGraph hg2) {
        this.graph = hg2;
    }

    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        Object result;
        HGPersistentHandle[] layout = this.graph.getStore().getLink(handle);
        if (targetSet == null || targetSet.deref().length == 0) {
            result = Array.newInstance(this.clazz, layout.length / 2);
        } else {
            if (this.linkConstructor == null) {
                throw new HGException("Unable to construct a link of type " + this.clazz.getName() + ", the class doesn't have a HGHandle [] based constructor.");
            }
            try {
                result = this.linkConstructor.newInstance(targetSet);
            }
            catch (Throwable t) {
                throw new HGException(t);
            }
        }
        TypeUtils.setValueFor(this.graph, handle, result);
        for (int i = 0; i < layout.length; i += 2) {
            Object current = null;
            HGPersistentHandle typeHandle = layout[i];
            HGPersistentHandle valueHandle = layout[i + 1];
            if (!typeHandle.equals(this.graph.getHandleFactory().nullHandle())) {
                HGAtomType type = this.graph.getTypeSystem().getType(typeHandle);
                current = TypeUtils.makeValue(this.graph, valueHandle, type);
            }
            ((Object[])result)[i / 2] = current;
        }
        return result;
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        HGPersistentHandle result = TypeUtils.getNewHandleFor(this.graph, instance);
        Object[] array = (Object[])instance;
        HGPersistentHandle[] layout = new HGPersistentHandle[array.length * 2];
        int pos = 0;
        for (int i = 0; i < array.length; ++i) {
            Object curr = array[i];
            if (curr == null) {
                layout[pos++] = this.graph.getHandleFactory().nullHandle();
                layout[pos++] = this.graph.getHandleFactory().nullHandle();
                continue;
            }
            HGHandle typeHandle = this.graph.getTypeSystem().getTypeHandle(curr.getClass());
            layout[pos++] = this.graph.getPersistentHandle(typeHandle);
            layout[pos++] = TypeUtils.storeValue(this.graph, curr, this.graph.getTypeSystem().getType(typeHandle));
        }
        this.graph.getStore().store(result, layout);
        return result;
    }

    @Override
    public void release(HGPersistentHandle handle) {
        HGPersistentHandle[] layout = this.graph.getStore().getLink(handle);
        for (int i = 0; i < layout.length; i += 2) {
            HGPersistentHandle typeHandle = layout[i];
            HGPersistentHandle valueHandle = layout[i + 1];
            if (typeHandle.equals(this.graph.getHandleFactory().nullHandle()) || TypeUtils.isValueReleased(this.graph, valueHandle)) continue;
            HGAtomType type = (HGAtomType)this.graph.get(typeHandle);
            TypeUtils.releaseValue(this.graph, type, valueHandle);
            type.release(valueHandle);
        }
        this.graph.getStore().removeLink(handle);
    }

    @Override
    public boolean subsumes(Object general, Object specific) {
        return false;
    }
}

