/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.transaction;

import java.lang.reflect.Field;

public class VBoxBody<E> {
    private static final Field NEXT_FIELD;
    public final long version;
    public final VBoxBody<E> next;
    public volatile E value;

    void setNext(VBoxBody<E> value) {
        try {
            NEXT_FIELD.set(this, value);
        }
        catch (IllegalAccessException iae) {
            throw new Error("JVSTM error: cannot set the next field to null");
        }
    }

    public VBoxBody(E value, long version, VBoxBody<E> next) {
        this.version = version;
        this.next = next;
        this.value = value;
    }

    public VBoxBody<E> getBody(long maxVersion) {
        VBoxBody<E> b = this;
        while (b.version > maxVersion) {
            b = b.next;
        }
        return b;
    }

    public void clearPrevious() {
        this.setNext(null);
    }

    static {
        try {
            NEXT_FIELD = VBoxBody.class.getDeclaredField("next");
            NEXT_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException nsfe) {
            throw new Error("JVSTM error: couldn't get access to the VBoxBody.next field");
        }
    }
}

