/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.transaction;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hypergraphdb.transaction.HGTransaction;
import org.hypergraphdb.transaction.TransactionBDBImpl;

public class TxMonitor {
    public Map<Integer, Info> txMap = Collections.synchronizedMap(new HashMap());

    public void transactionCreated(HGTransaction tx) {
        try {
            Info txInfo = new Info();
            txInfo.id = ((TransactionBDBImpl)tx.getStorageTransaction()).getBDBTransaction().getId();
            txInfo.threadName = Thread.currentThread().getName();
            StringBuffer b = new StringBuffer();
            for (StackTraceElement el : Thread.currentThread().getStackTrace()) {
                b.append(el.toString());
                b.append("\n");
            }
            txInfo.beginTrace = b.toString();
            this.txMap.put(txInfo.id, txInfo);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void transactionFinished(HGTransaction tx) {
        try {
            int id = ((TransactionBDBImpl)tx.getStorageTransaction()).getBDBTransaction().getId();
            this.txMap.remove(id);
            return;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
    }

    public static class Info {
        int id = 0;
        String threadName = null;
        String beginTrace = null;
        String endTrace = null;
    }
}

