/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.transaction;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hypergraphdb.transaction.HGTransaction;
import org.hypergraphdb.transaction.HGTransactionManager;
import org.hypergraphdb.transaction.VBox;
import org.hypergraphdb.transaction.VBoxBody;
import org.hypergraphdb.util.RefResolver;

public class TxMap<K, V>
implements Map<K, V> {
    protected Map<K, Box> M = null;
    protected HGTransactionManager txManager;
    protected RefResolver<Object, Box> boxGetter = null;
    protected VBox<Integer> sizebox = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Box getBox(Object key) {
        Map<K, Box> map = this.M;
        synchronized (map) {
            Box box = this.M.get(key);
            if (box == null) {
                box = new Box(this.txManager, key);
                this.M.put(key, box);
            }
            return box;
        }
    }

    public TxMap(HGTransactionManager tManager, Map backingMap) {
        this.txManager = tManager;
        this.M = backingMap == null ? new ConcurrentHashMap() : backingMap;
        this.sizebox = new VBox(this.txManager);
        this.sizebox.put(0);
        this.boxGetter = this.M instanceof ConcurrentMap ? new RefResolver<Object, Box>(){
            private ConcurrentMap<K, Box> cm;
            {
                this.cm = (ConcurrentMap)TxMap.this.M;
            }

            @Override
            public Box resolve(Object k) {
                Box box2;
                Box box = (Box)this.cm.get(k);
                if (box == null) {
                    box = new Box(TxMap.this.txManager, k);
                }
                return (box2 = this.cm.putIfAbsent(k, box)) != null ? box2 : box;
            }
        } : new RefResolver<Object, Box>(){

            @Override
            public Box resolve(Object k) {
                return TxMap.this.getBox(k);
            }
        };
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public V get(Object key) {
        return (V)this.boxGetter.resolve(key).get();
    }

    @Override
    public V put(K key, V value) {
        VBox box = this.boxGetter.resolve(key);
        Object old = box.get();
        if (old == null) {
            box.put(value);
            if (value != null) {
                this.sizebox.put(this.sizebox.get() + 1);
            }
        } else if (old != value) {
            box.put(value);
            if (value == null) {
                this.sizebox.put(this.sizebox.get() - 1);
            }
        }
        return (V)old;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        return this.put(key, null);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int mapSize() {
        return this.M.size();
    }

    @Override
    public int size() {
        return this.sizebox.get();
    }

    @Override
    public Set<K> keySet() {
        return null;
    }

    @Override
    public Collection<V> values() {
        return null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return null;
    }

    @Override
    public void clear() {
        this.M.clear();
    }

    protected class Box
    extends VBox<V> {
        WeakReference<K> key;

        public Box(HGTransactionManager txManager, K key) {
            super(txManager);
            this.key = new WeakReference(key);
        }

        @Override
        public VBoxBody<V> makeNewBody(V value, long version, VBoxBody<V> next) {
            return new BoxBody(value, version, next);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish(HGTransaction tx) {
            if (this.body.version == 0L) {
                Map map = TxMap.this.M;
                synchronized (map) {
                    TxMap.this.M.remove(this.key.get());
                }
            }
        }

        private class BoxBody
        extends VBoxBody<V> {
            public BoxBody(V value, long version, VBoxBody<V> next) {
                super(value, version, next);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearPrevious() {
                super.clearPrevious();
                if (this.value == null && Box.this.body == this) {
                    Map map = TxMap.this.M;
                    synchronized (map) {
                        TxMap.this.M.remove(Box.this.key.get());
                    }
                }
            }
        }
    }
}

