/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.transaction;

import java.util.List;
import org.hypergraphdb.transaction.HGTransaction;
import org.hypergraphdb.transaction.HGTransactionManager;
import org.hypergraphdb.transaction.TxSet;
import org.hypergraphdb.transaction.VBoxBody;
import org.hypergraphdb.util.HGSortedSet;
import org.hypergraphdb.util.RefCountedMap;
import org.hypergraphdb.util.RefResolver;

public class TxCacheSet<Key, E>
extends TxSet<E> {
    private Key key;
    private RefCountedMap<Key, TxSet.SetTxBox<E>> writeMap;
    private RefResolver<Key, ? extends HGSortedSet<E>> loader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VBoxBody<HGSortedSet<E>> insertBody(long txNumber, HGSortedSet<E> x) {
        this.txManager.COMMIT_LOCK.lock();
        try {
            if (txNumber >= this.txManager.mostRecentRecord.transactionNumber) {
                if (this.S.body.version == -1L) {
                    this.S.body = this.S.makeNewBody(x, txNumber, this.S.body.next);
                } else if (this.S.body.version < txNumber) {
                    this.S.body = this.S.makeNewBody(x, txNumber, this.S.body);
                }
                VBoxBody vBoxBody = this.S.body;
                return vBoxBody;
            }
            if (this.S.body.version == -1L && txNumber >= ((CacheSetTxBox)this.S).loadedAt) {
                this.S.body = this.S.makeNewBody(x, ((CacheSetTxBox)this.S).loadedAt, this.S.body.next);
                VBoxBody vBoxBody = this.S.body;
                return vBoxBody;
            }
            VBoxBody<HGSortedSet<E>> currentBody = this.S.body;
            while (currentBody.next != null && currentBody.next.version > txNumber) {
                currentBody = currentBody.next;
            }
            if (currentBody.next != null && currentBody.next.version == txNumber) {
                VBoxBody<HGSortedSet<E>> vBoxBody = currentBody.next;
                return vBoxBody;
            }
            VBoxBody<HGSortedSet<E>> newBody = this.S.makeNewBody(x, txNumber, currentBody.next);
            currentBody.setNext(newBody);
            VBoxBody<HGSortedSet<E>> vBoxBody = newBody;
            return vBoxBody;
        }
        finally {
            this.txManager.COMMIT_LOCK.unlock();
        }
    }

    VBoxBody<HGSortedSet<E>> load(long txNumber) {
        HGSortedSet<E> x = this.loader.resolve(this.key);
        return this.insertBody(txNumber, x);
    }

    @Override
    HGSortedSet<E> read() {
        HGTransaction tx = this.txManager.getContext().getCurrent();
        if (tx == null) {
            return (HGSortedSet)this.S.body.value;
        }
        HGSortedSet x = (HGSortedSet)tx.getLocalValue(this.S);
        if (x == null) {
            VBoxBody<HGSortedSet<E>> b = this.S.body;
            if (b.version <= tx.getNumber()) {
                if (b.value == null) {
                    b = this.load(tx.getNumber());
                }
            } else {
                while (b.version > tx.getNumber() && b.next != null) {
                    b = b.next;
                }
                if (b.version != tx.getNumber()) {
                    b = this.load(tx.getNumber());
                }
            }
            if (!tx.isReadOnly()) {
                tx.bodiesRead.put(this.S, b);
            }
            return (HGSortedSet)b.value;
        }
        return x == HGTransaction.NULL_VALUE ? null : x;
    }

    @Override
    HGSortedSet<E> write() {
        List log = (List)this.txManager.getContext().getCurrent().getAttribute(this.S);
        if (log == null) {
            HGSortedSet<E> readOnly = this.read();
            HGSortedSet<E> writeable = this.cloneSet(readOnly);
            this.S.put(writeable);
            this.writeMap.put(this.key, this.S);
        }
        return (HGSortedSet)this.S.get();
    }

    public TxCacheSet(HGTransactionManager txManager, HGSortedSet<E> backingSet, Key key, RefResolver<Key, ? extends HGSortedSet<E>> loader, RefCountedMap<Key, TxSet.SetTxBox<E>> writeMap) {
        this.txManager = txManager;
        this.key = key;
        this.loader = loader;
        this.writeMap = writeMap;
        HGTransaction tx = txManager.getContext().getCurrent();
        if (tx == null) {
            this.S = new CacheSetTxBox(txManager, backingSet, this);
            return;
        }
        this.S = writeMap.get(key);
        long txNumber = tx.getNumber();
        if (this.S == null) {
            this.S = new CacheSetTxBox(txManager, backingSet, this);
            this.S.body = this.S.makeNewBody(backingSet, txNumber, null);
            if (txNumber < txManager.mostRecentRecord.transactionNumber) {
                this.S.body = this.S.makeNewBody(null, -1L, this.S.body);
            }
        } else {
            this.insertBody(txNumber, backingSet);
        }
    }

    public static class CacheSetTxBox<Key, E>
    extends TxSet.SetTxBox<E> {
        long loadedAt;

        CacheSetTxBox(HGTransactionManager txManager, HGSortedSet<E> backingSet, TxSet<E> thisSet) {
            super(txManager, backingSet, thisSet);
            this.loadedAt = txManager.mostRecentRecord.transactionNumber;
        }

        @Override
        HGSortedSet<E> getLastCommitted(HGTransaction tx) {
            TxCacheSet s = (TxCacheSet)this.thisSet;
            HGSortedSet lastCommitted = super.getLastCommitted(tx);
            return lastCommitted == null ? (HGSortedSet)s.load((long)tx.getNumber()).value : lastCommitted;
        }

        @Override
        public VBoxBody<HGSortedSet<E>> commit(HGTransaction tx, HGSortedSet<E> newvalue, long txNumber) {
            VBoxBody latest = super.commit(tx, newvalue, txNumber);
            if (latest.next != null && latest.next.version == -1L) {
                latest.setNext(latest.next.next);
            }
            return latest;
        }

        @Override
        public void finish(HGTransaction tx) {
            if (tx.getAttribute(this) != null) {
                TxCacheSet s = (TxCacheSet)this.thisSet;
                s.writeMap.remove(s.key);
            }
        }
    }
}

