/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.transaction;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hypergraphdb.cache.CacheMap;
import org.hypergraphdb.transaction.HGTransaction;
import org.hypergraphdb.transaction.HGTransactionManager;
import org.hypergraphdb.transaction.TransactionConflictException;
import org.hypergraphdb.transaction.VBox;
import org.hypergraphdb.transaction.VBoxBody;
import org.hypergraphdb.util.RefCountedMap;
import org.hypergraphdb.util.RefResolver;
import org.hypergraphdb.util.WeakIdentityHashMap;

public class TxCacheMap<K, V>
implements CacheMap<K, V> {
    private RefCountedMap<K, Box> writeMap;
    private boolean weakrefs = false;
    protected Map<K, Box> M = null;
    protected HGTransactionManager txManager;
    protected RefResolver<Object, Box> boxGetter = null;
    protected VBox<Integer> sizebox = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Box getBox(Object key) {
        Map<K, Box> map = this.M;
        synchronized (map) {
            Box box = this.M.get(key);
            if (box != null) {
                return box;
            }
            box = this.writeMap.get(key);
            if (box != null) {
                this.M.put(key, box);
                return box;
            }
            box = this.weakrefs ? new WeakBox(this.txManager, key) : new StrongBox(this.txManager, key);
            this.M.put(key, box);
            return box;
        }
    }

    public TxCacheMap(HGTransactionManager tManager, Class<? extends Map> mapImplementation) {
        this.txManager = tManager;
        this.sizebox = new VBox(this.txManager);
        this.sizebox.put(0);
        if (mapImplementation != null) {
            this.weakrefs = WeakHashMap.class.isAssignableFrom(mapImplementation) || WeakIdentityHashMap.class.isAssignableFrom(mapImplementation);
        }
        try {
            this.M = mapImplementation == null ? new ConcurrentHashMap<K, Box>() : mapImplementation.newInstance();
            this.writeMap = new RefCountedMap(new HashMap());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.boxGetter = this.M instanceof ConcurrentMap ? new RefResolver<Object, Box>(){
            private ConcurrentMap<K, Box> c_map;
            private Map<K, Box> cwrite_map;
            {
                this.c_map = (ConcurrentMap)TxCacheMap.this.M;
                this.cwrite_map = TxCacheMap.this.writeMap;
            }

            @Override
            public Box resolve(Object k) {
                Box box = (Box)this.c_map.get(k);
                if (box != null) {
                    return box;
                }
                box = this.cwrite_map.get(k);
                if (box != null) {
                    this.c_map.putIfAbsent(k, box);
                    return box;
                }
                box = TxCacheMap.this.weakrefs ? new WeakBox(TxCacheMap.this.txManager, k) : new StrongBox(TxCacheMap.this.txManager, k);
                Box box2 = this.c_map.putIfAbsent(k, box);
                return box2 != null ? box2 : box;
            }
        } : new RefResolver<Object, Box>(){

            @Override
            public Box resolve(Object k) {
                return TxCacheMap.this.getBox(k);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Box boxOf(Object key) {
        if (this.M instanceof ConcurrentMap) {
            return this.M.get(key);
        }
        Map<K, Box> map = this.M;
        synchronized (map) {
            return this.M.get(key);
        }
    }

    @Override
    public void put(K key, V value) {
        Box box;
        HGTransaction tx = this.txManager.getContext().getCurrent();
        if (tx.getLocalValue(box = this.boxGetter.resolve(key)) == null) {
            this.writeMap.put(key, box);
        }
        V old = this.get((Object)key);
        box.put(value);
        if (old == null) {
            if (value != null) {
                this.sizebox.put(this.sizebox.get() + 1);
            }
        } else if (value == null) {
            this.sizebox.put(this.sizebox.get() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(K key, V value) {
        this.txManager.COMMIT_LOCK.lock();
        try {
            Box box = this.boxGetter.resolve(key);
            HGTransaction tx = this.txManager.getContext().getCurrent();
            VBoxBody<Object> read = null;
            if (box.body.version == -1L) {
                if (tx.getNumber() >= this.txManager.mostRecentRecord.transactionNumber || tx == null) {
                    box.body = box.makeNewBody(value, tx.getNumber(), box.body.next);
                    read = box.body;
                } else {
                    VBoxBody<V> curr = box.body;
                    while (curr.next != null && curr.next.version > tx.getNumber()) {
                        curr = curr.next;
                    }
                    if (curr.next != null && curr.next.version == tx.getNumber()) {
                        curr.next.value = value;
                    } else {
                        curr.setNext(box.makeNewBody(value, tx.getNumber(), curr.next));
                    }
                    read = curr.next;
                }
            } else if (tx.getNumber() >= box.body.version) {
                box.body.value = value;
                read = box.body;
            } else {
                VBoxBody curr = box.body;
                while (curr.next != null && curr.next.version > tx.getNumber()) {
                    curr = curr.next;
                }
                if (curr.next.version == tx.getNumber()) {
                    curr.next.value = value;
                    read = curr.next;
                } else {
                    read = box.makeNewBody(value, tx.getNumber(), curr.next);
                    curr.setNext(read);
                }
            }
            if (!tx.isReadOnly()) {
                tx.bodiesRead.put(box, read);
            }
        }
        finally {
            this.txManager.COMMIT_LOCK.unlock();
        }
    }

    @Override
    public V get(Object key) {
        Box box = this.boxGetter.resolve(key);
        HGTransaction tx = this.txManager.getContext().getCurrent();
        if (tx == null) {
            return (V)box.body.value;
        }
        Object value = tx.getLocalValue(box);
        if (value == null) {
            VBoxBody b = box.body;
            if (b.version <= tx.getNumber() && b.version != -1L) {
                value = b.value;
                if (!tx.isReadOnly()) {
                    tx.bodiesRead.put(box, b);
                }
            } else {
                if (b.version == -1L) {
                    b = b.next;
                } else if (!tx.isReadOnly()) {
                    throw new TransactionConflictException();
                }
                while (b != null && b.version > tx.getNumber()) {
                    b = b.next;
                }
                if (b != null && b.version == tx.getNumber()) {
                    value = b.value;
                    if (!tx.isReadOnly()) {
                        tx.bodiesRead.put(box, b);
                    }
                }
            }
        }
        return value == HGTransaction.NULL_VALUE ? null : (V)value;
    }

    @Override
    public void remove(Object key) {
        this.put(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(Object key) {
        if (this.M instanceof ConcurrentMap) {
            this.M.remove(key);
        } else {
            Map<K, Box> map = this.M;
            synchronized (map) {
                this.M.remove(key);
            }
        }
    }

    public int mapSize() {
        return this.M.size();
    }

    @Override
    public int size() {
        return this.sizebox.get();
    }

    @Override
    public void clear() {
        this.M.clear();
    }

    protected class WeakBox
    extends Box {
        final WeakReference<K> key;

        public WeakBox(HGTransactionManager txManager, K key) {
            super(txManager);
            this.key = new WeakReference(key);
        }

        @Override
        public K getKey() {
            return this.key.get();
        }
    }

    protected class StrongBox
    extends Box {
        final K key;

        public StrongBox(HGTransactionManager txManager, K key) {
            super(txManager);
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }
    }

    public abstract class Box
    extends VBox<V> {
        public Box(HGTransactionManager txManager) {
            this.txManager = txManager;
            this.body = this.makeNewBody(null, -1L, null);
        }

        public VBoxBody<V> getBody() {
            return this.body;
        }

        public abstract K getKey();

        public VBoxBody<V> commitImmediately(HGTransaction tx, V newValue, long txNumber) {
            return super.commit(tx, newValue, txNumber);
        }

        @Override
        public VBoxBody<V> commit(HGTransaction tx, V newValue, long txNumber) {
            if (this.body.version == -1L) {
                this.body = this.makeNewBody(newValue, tx.getNumber(), this.body.next);
                return this.body;
            }
            return super.commit(tx, newValue, tx.getNumber());
        }

        @Override
        public void finish(HGTransaction tx) {
            if (tx.getLocalValue(this) != null) {
                TxCacheMap.this.writeMap.remove(this.getKey());
            }
            if (this.body.value == null && this.body.version == 0L && this.body.next == null) {
                TxCacheMap.this.drop(this.getKey());
            }
        }
    }
}

