/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.transaction;

import com.sleepycat.db.DeadlockException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.transaction.ActiveTransactionsRecord;
import org.hypergraphdb.transaction.DefaultTransactionContext;
import org.hypergraphdb.transaction.HGStorageTransaction;
import org.hypergraphdb.transaction.HGTransaction;
import org.hypergraphdb.transaction.HGTransactionConfig;
import org.hypergraphdb.transaction.HGTransactionContext;
import org.hypergraphdb.transaction.HGTransactionException;
import org.hypergraphdb.transaction.HGTransactionFactory;
import org.hypergraphdb.transaction.HGUserAbortException;
import org.hypergraphdb.transaction.TransactionConflictException;
import org.hypergraphdb.transaction.TxMonitor;
import org.hypergraphdb.transaction.VanillaTransaction;

public class HGTransactionManager {
    private HyperGraph graph;
    private HGTransactionFactory factory;
    private ThreadLocal<HGTransactionContext> tcontext = new ThreadLocal();
    private boolean enabled = true;
    volatile ActiveTransactionsRecord mostRecentRecord = new ActiveTransactionsRecord(0L, null);
    final ReentrantLock COMMIT_LOCK = new ReentrantLock(true);
    TxMonitor txMonitor = null;
    public AtomicInteger conflicted = new AtomicInteger(0);
    public AtomicInteger successful = new AtomicInteger(0);

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public HGTransactionContext getContext() {
        HGTransactionContext ctx = this.tcontext.get();
        if (ctx == null) {
            ctx = new DefaultTransactionContext(this);
            this.tcontext.set(ctx);
        }
        return ctx;
    }

    public HGTransactionManager(HGTransactionFactory factory) {
        this.factory = factory;
    }

    public void setHyperGraph(HyperGraph graph) {
        this.graph = graph;
    }

    public HyperGraph getHyperGraph() {
        return this.graph;
    }

    public void threadAttach(HGTransactionContext tContext) {
        this.tcontext.set(tContext);
    }

    public void threadDetach() {
        this.tcontext.set(null);
    }

    HGTransaction createTransaction(HGTransaction parent, HGTransactionConfig config) {
        HGStorageTransaction storageTx = config.isNoStorage() ? null : this.factory.createTransaction(this.getContext(), config, parent);
        ActiveTransactionsRecord activeRecord = this.mostRecentRecord.getRecordForNewTransaction();
        if (this.enabled) {
            HGTransaction result = new HGTransaction(this.getContext(), parent, activeRecord, storageTx, config.isReadonly());
            if (this.txMonitor != null) {
                this.txMonitor.transactionCreated(result);
            }
            return result;
        }
        return new HGTransaction(this.getContext(), parent, activeRecord, new VanillaTransaction(), config.isReadonly());
    }

    public void beginTransaction() {
        this.beginTransaction(HGTransactionConfig.DEFAULT);
    }

    public void beginTransaction(HGTransactionConfig config) {
        this.getContext().beginTransaction(config);
    }

    public void endTransaction(boolean success) throws HGTransactionException {
        HGTransactionContext ctx = this.tcontext.get();
        if (ctx == null) {
            throw new HGException("Attempt to end a transaction with no transaction context currently active.");
        }
        ctx.endTransaction(success);
    }

    public void commit() {
        try {
            this.endTransaction(true);
        }
        catch (HGTransactionException ex) {
            throw new HGException(ex);
        }
    }

    public void abort() {
        try {
            this.endTransaction(false);
        }
        catch (HGTransactionException ex) {
            throw new HGException(ex);
        }
    }

    public <V> V ensureTransaction(Callable<V> transaction) {
        return this.ensureTransaction(transaction, HGTransactionConfig.DEFAULT);
    }

    public <V> V ensureTransaction(Callable<V> transaction, HGTransactionConfig config) {
        if (this.getContext().getCurrent() != null) {
            try {
                return transaction.call();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.transact(transaction, config);
    }

    private void handleTxException(Throwable t) {
        boolean retry = false;
        for (Throwable cause = t; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof DeadlockException) && !(cause instanceof TransactionConflictException)) continue;
            retry = true;
            break;
        }
        if (!retry) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new HGException(t);
        }
    }

    public <V> V transact(Callable<V> transaction) {
        return this.transact(transaction, HGTransactionConfig.DEFAULT);
    }

    public <V> V transact(Callable<V> transaction, HGTransactionConfig config) {
        while (true) {
            this.beginTransaction(config);
            V result = null;
            try {
                result = transaction.call();
            }
            catch (HGUserAbortException ex) {
                try {
                    this.endTransaction(false);
                }
                catch (HGTransactionException tex) {
                    tex.printStackTrace(System.err);
                }
                return null;
            }
            catch (Throwable t) {
                try {
                    this.endTransaction(false);
                }
                catch (HGTransactionException tex) {
                    tex.printStackTrace(System.err);
                }
                this.handleTxException(t);
                this.conflicted.incrementAndGet();
                continue;
            }
            try {
                this.endTransaction(true);
                this.successful.incrementAndGet();
                return result;
            }
            catch (Throwable t) {
                this.handleTxException(t);
                this.conflicted.incrementAndGet();
                continue;
            }
            break;
        }
    }
}

