/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.transaction;

import java.util.Stack;
import org.hypergraphdb.HGException;
import org.hypergraphdb.transaction.HGTransaction;
import org.hypergraphdb.transaction.HGTransactionConfig;
import org.hypergraphdb.transaction.HGTransactionContext;
import org.hypergraphdb.transaction.HGTransactionException;
import org.hypergraphdb.transaction.HGTransactionManager;

class DefaultTransactionContext
implements HGTransactionContext {
    private Stack<HGTransaction> tstack = new Stack();
    private HGTransactionManager manager = null;

    DefaultTransactionContext(HGTransactionManager manager) {
        this.manager = manager;
    }

    @Override
    public HGTransactionManager getManager() {
        return this.manager;
    }

    @Override
    public HGTransaction getCurrent() {
        return this.tstack.isEmpty() ? null : this.tstack.peek();
    }

    @Override
    public void beginTransaction(HGTransactionConfig config) {
        if (this.tstack.isEmpty()) {
            this.tstack.push(this.manager.createTransaction(null, config));
        } else {
            this.tstack.push(this.manager.createTransaction(this.tstack.peek(), config));
        }
    }

    @Override
    public void endTransaction(boolean success) throws HGTransactionException {
        if (this.tstack.isEmpty()) {
            throw new HGException("Attempt to end a transaction for an empty transaction context.");
        }
        HGTransaction top = this.tstack.pop();
        if (this.manager.txMonitor != null) {
            this.manager.txMonitor.transactionFinished(top);
        }
        if (success) {
            top.commit();
        } else {
            top.abort();
        }
    }

    @Override
    public void endAll(boolean success) throws HGTransactionException {
        if (success) {
            while (!this.tstack.isEmpty()) {
                HGTransaction tx = this.tstack.pop();
                if (this.manager.txMonitor != null) {
                    this.manager.txMonitor.transactionFinished(tx);
                }
                tx.commit();
            }
        } else {
            while (!this.tstack.isEmpty()) {
                HGTransaction tx = this.tstack.pop();
                if (this.manager.txMonitor != null) {
                    this.manager.txMonitor.transactionFinished(tx);
                }
                tx.abort();
            }
        }
    }
}

