/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.transaction;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.Lock;
import com.sleepycat.db.LockNotGrantedException;
import com.sleepycat.db.LockRequestMode;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReadWriteLock;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.transaction.TransactionBDBImpl;

public class BDBTxLock
implements ReadWriteLock {
    private HyperGraph graph;
    private DatabaseEntry objectId;
    private BDBReadLock readLock = new BDBReadLock();
    private BDBWriteLock writeLock = new BDBWriteLock();

    private int getLockerId() {
        try {
            return ((TransactionBDBImpl)this.graph.getTransactionManager().getContext().getCurrent().getStorageTransaction()).getBDBTransaction().getId();
        }
        catch (DatabaseException ex) {
            throw new HGException(ex);
        }
    }

    private Environment getEnv() {
        return ((TransactionBDBImpl)this.graph.getTransactionManager().getContext().getCurrent().getStorageTransaction()).getBDBEnvironment();
    }

    public BDBTxLock(HyperGraph graph, byte[] objectId) {
        this(graph, new DatabaseEntry(objectId));
    }

    public BDBTxLock(HyperGraph graph, DatabaseEntry objectId) {
        this.graph = graph;
        this.objectId = new DatabaseEntry();
        byte[] tmp = new byte[objectId.getData().length];
        System.arraycopy(objectId.getData(), 0, tmp, 0, tmp.length);
        this.objectId = new DatabaseEntry(tmp);
    }

    @Override
    public java.util.concurrent.locks.Lock readLock() {
        return this.readLock;
    }

    @Override
    public java.util.concurrent.locks.Lock writeLock() {
        return this.writeLock;
    }

    public HyperGraph getGraph() {
        return this.graph;
    }

    public byte[] getObjectId() {
        return this.objectId.getData();
    }

    private class BDBWriteLock
    implements java.util.concurrent.locks.Lock {
        Lock lock;
        ThreadLocal<Integer> writeCount = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };

        BDBWriteLock() {
            this.writeCount.set(new Integer(0));
        }

        @Override
        public void lock() {
            try {
                if (this.writeCount.get() == 0) {
                    this.lock = BDBTxLock.this.getEnv().getLock(BDBTxLock.this.getLockerId(), false, BDBTxLock.this.objectId, LockRequestMode.WRITE);
                }
                this.writeCount.set(this.writeCount.get() + 1);
            }
            catch (DatabaseException ex) {
                throw new HGException(ex);
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            try {
                if (this.writeCount.get() == 0) {
                    this.lock = BDBTxLock.this.getEnv().getLock(BDBTxLock.this.getLockerId(), true, BDBTxLock.this.objectId, LockRequestMode.WRITE);
                }
                if (this.lock != null) {
                    this.writeCount.set(this.writeCount.get() + 1);
                    return true;
                }
                return false;
            }
            catch (LockNotGrantedException le) {
                return false;
            }
            catch (DatabaseException ex) {
                throw new HGException(ex);
            }
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void unlock() {
            try {
                int newcnt = this.writeCount.get() - 1;
                if (newcnt < 0) {
                    throw new IllegalStateException("Lock already released.");
                }
                if (newcnt == 0) {
                    BDBTxLock.this.getEnv().putLock(this.lock);
                    this.lock = null;
                }
                this.writeCount.set(newcnt);
            }
            catch (DatabaseException ex) {
                throw new HGException(ex);
            }
        }
    }

    private class BDBReadLock
    implements java.util.concurrent.locks.Lock {
        Lock lock = null;
        ThreadLocal<Integer> readCount = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };

        BDBReadLock() {
        }

        @Override
        public synchronized void lock() {
            try {
                if (this.readCount.get() == 0) {
                    this.lock = BDBTxLock.this.getEnv().getLock(BDBTxLock.this.getLockerId(), false, BDBTxLock.this.objectId, LockRequestMode.READ);
                }
                this.readCount.set(this.readCount.get() + 1);
            }
            catch (DatabaseException ex) {
                throw new HGException(ex);
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized boolean tryLock() {
            try {
                if (this.readCount.get() == 0) {
                    this.lock = BDBTxLock.this.getEnv().getLock(BDBTxLock.this.getLockerId(), true, BDBTxLock.this.objectId, LockRequestMode.READ);
                }
                if (this.lock != null) {
                    this.readCount.set(this.readCount.get() + 1);
                    return true;
                }
                return false;
            }
            catch (LockNotGrantedException le) {
                return false;
            }
            catch (DatabaseException ex) {
                throw new HGException(ex);
            }
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public synchronized void unlock() {
            try {
                if (this.lock != null) {
                    int newcnt = this.readCount.get() - 1;
                    if (newcnt < 0) {
                        throw new IllegalStateException("Lock already released.");
                    }
                    if (newcnt == 0) {
                        BDBTxLock.this.getEnv().putLock(this.lock);
                        this.lock = null;
                    }
                    this.readCount.set(newcnt);
                }
            }
            catch (DatabaseException ex) {
                throw new HGException(ex);
            }
        }
    }
}

