/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.transaction;

import com.sleepycat.db.Cursor;
import com.sleepycat.db.DatabaseException;
import org.hypergraphdb.HGException;
import org.hypergraphdb.transaction.TransactionBDBImpl;
import org.hypergraphdb.util.CloseMe;

public final class BDBTxCursor
implements CloseMe {
    private TransactionBDBImpl tx;
    private Cursor cursor = null;
    private boolean open = true;

    public BDBTxCursor(Cursor cursor, TransactionBDBImpl tx) {
        this.cursor = cursor;
        this.tx = tx;
        this.open = cursor != null;
    }

    public Cursor cursor() {
        return this.cursor;
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() {
        if (!this.open) {
            return;
        }
        try {
            this.cursor.close();
        }
        catch (DatabaseException ex) {
            throw new HGException(ex);
        }
        finally {
            this.open = false;
            this.cursor = null;
            if (this.tx != null) {
                this.tx.removeCursor(this);
            }
        }
    }
}

