/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.storage;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGRandomAccessResult;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.util.HGSortedSet;

public class StorageBasedIncidenceSet
implements HGSortedSet<HGHandle> {
    private HGHandle atom;
    private HyperGraph graph;

    public StorageBasedIncidenceSet(HGHandle atom, HyperGraph graph) {
        this.atom = atom;
        this.graph = graph;
    }

    @Override
    public HGRandomAccessResult<HGHandle> getSearchResult() {
        return this.graph.getStore().getIncidenceResultSet(this.graph.getPersistentHandle(this.atom));
    }

    @Override
    public Comparator<? super HGHandle> comparator() {
        return new Comparator(){

            public int compare(Object x, Object y) {
                return ((Comparable)x).compareTo(y);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HGHandle first() {
        HGRandomAccessResult<HGHandle> rs = this.getSearchResult();
        try {
            if (!rs.hasNext()) {
                throw new NoSuchElementException();
            }
            HGHandle hGHandle = (HGHandle)rs.next();
            return hGHandle;
        }
        finally {
            rs.close();
        }
    }

    @Override
    public SortedSet<HGHandle> headSet(HGHandle toElement) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HGHandle last() {
        HGRandomAccessResult<HGHandle> rs = this.getSearchResult();
        try {
            rs.goAfterLast();
            if (!rs.hasPrev()) {
                throw new NoSuchElementException();
            }
            HGHandle hGHandle = (HGHandle)rs.prev();
            return hGHandle;
        }
        finally {
            rs.close();
        }
    }

    @Override
    public SortedSet<HGHandle> subSet(HGHandle fromElement, HGHandle toElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<HGHandle> tailSet(HGHandle fromElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(HGHandle e) {
        if (this.contains(e)) {
            return false;
        }
        this.graph.getStore().addIncidenceLink(this.graph.getPersistentHandle(this.atom), this.graph.getPersistentHandle(e));
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends HGHandle> c) {
        boolean modified = false;
        for (HGHandle hGHandle : c) {
            modified = modified || this.add(hGHandle);
        }
        return modified;
    }

    @Override
    public void clear() {
        this.graph.getStore().removeIncidenceSet(this.graph.getPersistentHandle(this.atom));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        HGRandomAccessResult<HGHandle> rs = this.getSearchResult();
        try {
            boolean bl = rs.goTo((HGHandle)o, true) == HGRandomAccessResult.GotoResult.found;
            return bl;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        HGRandomAccessResult<HGHandle> rs = this.getSearchResult();
        try {
            for (HGHandle x : c) {
                if (rs.goTo(x, true) == HGRandomAccessResult.GotoResult.found) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        HGRandomAccessResult<HGHandle> rs = this.getSearchResult();
        try {
            boolean bl = !rs.hasNext();
            return bl;
        }
        finally {
            rs.close();
        }
    }

    @Override
    public Iterator<HGHandle> iterator() {
        throw new UnsupportedOperationException("Use getSearchResult and make sure you close it.");
    }

    @Override
    public boolean remove(Object o) {
        if (this.contains(o)) {
            this.graph.getStore().removeIncidenceLink(this.graph.getPersistentHandle(this.atom), this.graph.getPersistentHandle((HGHandle)o));
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object x : c) {
            modified = modified || this.remove(x);
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return (int)this.graph.getStore().getIncidenceSetCardinality(this.graph.getPersistentHandle(this.atom));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        HGRandomAccessResult<HGHandle> rs = this.getSearchResult();
        try {
            int size = this.size();
            Object[] a = new Object[size];
            for (int i = 0; i < size; ++i) {
                a[i] = rs.next();
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        HGRandomAccessResult<HGHandle> rs = this.getSearchResult();
        try {
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            for (int i = 0; i < size; ++i) {
                a[i] = rs.next();
            }
            if (a.length > size) {
                a[size] = null;
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            rs.close();
        }
    }
}

