/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.storage;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.storage.StorageGraph;
import org.hypergraphdb.util.Pair;

public class RAMStorageGraph
implements StorageGraph {
    private Set<HGPersistentHandle> roots;
    private Map<HGPersistentHandle, Object> map = new HashMap<HGPersistentHandle, Object>();

    public RAMStorageGraph(HGPersistentHandle root) {
        this.roots = new HashSet<HGPersistentHandle>();
        this.roots.add(root);
    }

    public RAMStorageGraph(Set<HGPersistentHandle> roots) {
        this.roots = roots;
    }

    public void translateHandles(Map<HGPersistentHandle, HGPersistentHandle> subst) {
        HashMap<HGPersistentHandle, Object> translated = new HashMap<HGPersistentHandle, Object>();
        for (Map.Entry<HGPersistentHandle, Object> e : this.map.entrySet()) {
            HGPersistentHandle h;
            if (e.getValue() instanceof HGPersistentHandle[]) {
                HGPersistentHandle[] A = (HGPersistentHandle[])e.getValue();
                for (int i = 0; i < A.length; ++i) {
                    HGPersistentHandle h2 = subst.get(A[i]);
                    if (h2 == null) continue;
                    A[i] = h2;
                }
            }
            if ((h = subst.get(e.getKey())) == null) {
                h = e.getKey();
            }
            translated.put(h, e.getValue());
        }
        this.map = translated;
    }

    public void put(HGPersistentHandle handle, HGPersistentHandle[] linkData) {
        this.map.put(handle, linkData);
    }

    public void put(HGPersistentHandle handle, byte[] data) {
        this.map.put(handle, data);
    }

    @Override
    public byte[] getData(HGPersistentHandle handle) {
        return (byte[])this.map.get(handle);
    }

    @Override
    public HGPersistentHandle[] getLink(HGPersistentHandle handle) {
        return (HGPersistentHandle[])this.map.get(handle);
    }

    @Override
    public Set<HGPersistentHandle> getRoots() {
        return this.roots;
    }

    @Override
    public Iterator<Pair<HGPersistentHandle, Object>> iterator() {
        return new Iterator<Pair<HGPersistentHandle, Object>>(){
            final Iterator<Map.Entry<HGPersistentHandle, Object>> i;
            {
                this.i = RAMStorageGraph.this.map.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public Pair<HGPersistentHandle, Object> next() {
                Map.Entry<HGPersistentHandle, Object> e = this.i.next();
                return new Pair<HGPersistentHandle, Object>(e.getKey(), e.getValue());
            }

            @Override
            public void remove() {
                this.i.remove();
            }
        };
    }
}

