/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.storage;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGRandomAccessResult;
import org.hypergraphdb.storage.ByteArrayConverter;
import org.hypergraphdb.storage.IndexResultSet;
import org.hypergraphdb.transaction.BDBTxCursor;
import org.hypergraphdb.util.HGUtils;

public class KeyScanResultSet<T>
extends IndexResultSet<T> {
    @Override
    protected T advance() {
        try {
            OperationStatus status = this.cursor.cursor().getNextNoDup(this.key, this.data, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                return this.converter.fromByteArray(this.key.getData());
            }
            return null;
        }
        catch (Throwable t) {
            this.closeNoException();
            throw new HGException(t);
        }
    }

    @Override
    protected T back() {
        try {
            OperationStatus status = this.cursor.cursor().getPrevNoDup(this.key, this.data, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                return this.converter.fromByteArray(this.key.getData());
            }
            return null;
        }
        catch (Throwable t) {
            this.closeNoException();
            throw new HGException(t);
        }
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    public KeyScanResultSet(BDBTxCursor cursor, DatabaseEntry keyIn, ByteArrayConverter<T> converter) {
        this.converter = converter;
        this.cursor = cursor;
        this.key = new DatabaseEntry();
        if (keyIn != null) {
            this.assignData(this.key, keyIn.getData());
        }
        try {
            cursor.cursor().getCurrent(this.key, this.data, LockMode.DEFAULT);
            this.next = converter.fromByteArray(this.key.getData());
            this.lookahead = 1;
        }
        catch (Throwable t) {
            throw new HGException(t);
        }
    }

    @Override
    public HGRandomAccessResult.GotoResult goTo(T value, boolean exactMatch) {
        byte[] B = this.converter.toByteArray(value);
        this.assignData(this.key, B);
        try {
            if (exactMatch) {
                if (this.cursor.cursor().getSearchKey(this.key, this.data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                    this.positionToCurrent(this.key.getData());
                    return HGRandomAccessResult.GotoResult.found;
                }
                return HGRandomAccessResult.GotoResult.nothing;
            }
            if (this.cursor.cursor().getSearchKeyRange(this.key, this.data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                this.positionToCurrent(this.key.getData());
                return HGUtils.eq(B, this.key.getData()) ? HGRandomAccessResult.GotoResult.found : HGRandomAccessResult.GotoResult.close;
            }
            return HGRandomAccessResult.GotoResult.nothing;
        }
        catch (Throwable t) {
            this.closeNoException();
            throw new HGException(t);
        }
    }
}

