/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.storage;

import com.sleepycat.db.BtreeStats;
import com.sleepycat.db.Cursor;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.DatabaseType;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.Transaction;
import java.util.Comparator;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGRandomAccessResult;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HGSortIndex;
import org.hypergraphdb.storage.BDBStorageImplementation;
import org.hypergraphdb.storage.ByteArrayConverter;
import org.hypergraphdb.storage.KeyRangeBackwardResultSet;
import org.hypergraphdb.storage.KeyRangeForwardResultSet;
import org.hypergraphdb.storage.KeyScanResultSet;
import org.hypergraphdb.storage.SearchResultWrapper;
import org.hypergraphdb.storage.SingleKeyResultSet;
import org.hypergraphdb.transaction.HGTransaction;
import org.hypergraphdb.transaction.HGTransactionManager;
import org.hypergraphdb.transaction.TransactionBDBImpl;
import org.hypergraphdb.transaction.VanillaTransaction;

public class DefaultIndexImpl<KeyType, ValueType>
implements HGSortIndex<KeyType, ValueType> {
    public static final String DB_NAME_PREFIX = "hgstore_idx_";
    protected BDBStorageImplementation storage;
    protected CursorConfig cursorConfig = new CursorConfig();
    protected HGTransactionManager transactionManager;
    protected String name;
    protected Database db;
    private boolean owndb;
    protected Comparator comparator;
    protected boolean sort_duplicates = true;
    protected ByteArrayConverter<KeyType> keyConverter;
    protected ByteArrayConverter<ValueType> valueConverter;

    protected void checkOpen() {
        if (!this.isOpen()) {
            throw new HGException("Attempting to operate on index '" + this.name + "' while the index is being closed.");
        }
    }

    protected TransactionBDBImpl txn() {
        HGTransaction tx = this.transactionManager.getContext().getCurrent();
        if (tx == null || tx.getStorageTransaction() instanceof VanillaTransaction) {
            return TransactionBDBImpl.nullTransaction();
        }
        return (TransactionBDBImpl)tx.getStorageTransaction();
    }

    public DefaultIndexImpl(String indexName, BDBStorageImplementation storage, HGTransactionManager transactionManager, ByteArrayConverter<KeyType> keyConverter, ByteArrayConverter<ValueType> valueConverter, Comparator comparator) {
        this.name = indexName;
        this.storage = storage;
        this.transactionManager = transactionManager;
        this.keyConverter = keyConverter;
        this.valueConverter = valueConverter;
        this.comparator = comparator;
        this.owndb = true;
    }

    public String getName() {
        return this.name;
    }

    public String getDatabaseName() {
        return DB_NAME_PREFIX + this.name;
    }

    public Comparator getComparator() {
        try {
            if (this.comparator != null) {
                return this.comparator;
            }
            if (this.db.getConfig().getType() == DatabaseType.BTREE) {
                return this.db.getConfig().getBtreeComparator();
            }
            return this.db.getConfig().getHashComparator();
        }
        catch (DatabaseException ex) {
            throw new HGException(ex);
        }
    }

    @Override
    public void open() {
        try {
            DatabaseConfig dbConfig = this.storage.getConfiguration().getDatabaseConfig().cloneConfig();
            if (this.storage.getBerkleyEnvironment().getConfig().getTransactional() && this.storage.getConfiguration().isStorageMVCC()) {
                this.cursorConfig.setSnapshot(true);
            }
            dbConfig.setSortedDuplicates(this.sort_duplicates);
            if (this.comparator != null) {
                if (dbConfig.getType() == DatabaseType.BTREE) {
                    dbConfig.setBtreeComparator(this.comparator);
                } else {
                    dbConfig.setHashComparator(this.comparator);
                }
            }
            this.db = this.storage.getBerkleyEnvironment().openDatabase(null, DB_NAME_PREFIX + this.name, null, dbConfig);
        }
        catch (Throwable t) {
            throw new HGException("While attempting to open index ;" + this.name + "': " + t.toString(), t);
        }
    }

    @Override
    public void close() {
        if (this.db == null || !this.owndb) {
            return;
        }
        try {
            this.db.close();
        }
        catch (Throwable t) {
            throw new HGException(t);
        }
        finally {
            this.db = null;
        }
    }

    @Override
    public boolean isOpen() {
        return this.db != null;
    }

    @Override
    public HGRandomAccessResult<ValueType> scanValues() {
        HGRandomAccessResult<? extends Object> result;
        block8: {
            this.checkOpen();
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            result = null;
            Cursor cursor = null;
            try {
                TransactionBDBImpl tx = this.txn();
                cursor = this.db.openCursor(tx.getBDBTransaction(), this.cursorConfig);
                OperationStatus status = cursor.getFirst(keyEntry, value, LockMode.DEFAULT);
                if (status == OperationStatus.SUCCESS && cursor.count() > 0) {
                    result = new KeyRangeForwardResultSet<ValueType>(tx.attachCursor(cursor), keyEntry, this.valueConverter);
                    break block8;
                }
                try {
                    cursor.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                result = HGSearchResult.EMPTY;
            }
            catch (Throwable ex) {
                if (cursor != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                throw new HGException("Failed to lookup index '" + this.name + "': " + ex.toString(), ex);
            }
        }
        return result;
    }

    @Override
    public HGRandomAccessResult<KeyType> scanKeys() {
        HGRandomAccessResult<? extends Object> result;
        block8: {
            this.checkOpen();
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            result = null;
            Cursor cursor = null;
            try {
                TransactionBDBImpl tx = this.txn();
                cursor = this.db.openCursor(tx.getBDBTransaction(), this.cursorConfig);
                OperationStatus status = cursor.getFirst(keyEntry, value, LockMode.DEFAULT);
                if (status == OperationStatus.SUCCESS && cursor.count() > 0) {
                    result = new KeyScanResultSet<KeyType>(tx.attachCursor(cursor), keyEntry, this.keyConverter);
                    break block8;
                }
                try {
                    cursor.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                result = HGSearchResult.EMPTY;
            }
            catch (Throwable ex) {
                if (cursor != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                throw new HGException("Failed to lookup index '" + this.name + "': " + ex.toString(), ex);
            }
        }
        return result;
    }

    @Override
    public void addEntry(KeyType key, ValueType value) {
        this.checkOpen();
        DatabaseEntry dbkey = new DatabaseEntry(this.keyConverter.toByteArray(key));
        DatabaseEntry dbvalue = new DatabaseEntry(this.valueConverter.toByteArray(value));
        try {
            OperationStatus result = this.db.putNoDupData(this.txn().getBDBTransaction(), dbkey, dbvalue);
            if (result != OperationStatus.SUCCESS && result != OperationStatus.KEYEXIST) {
                throw new Exception("OperationStatus: " + result);
            }
        }
        catch (Exception ex) {
            throw new HGException("Failed to add entry to index '" + this.name + "': " + ex.toString(), ex);
        }
    }

    @Override
    public void removeEntry(KeyType key, ValueType value) {
        this.checkOpen();
        DatabaseEntry keyEntry = new DatabaseEntry(this.keyConverter.toByteArray(key));
        DatabaseEntry valueEntry = new DatabaseEntry(this.valueConverter.toByteArray(value));
        Cursor cursor = null;
        try {
            cursor = this.db.openCursor(this.txn().getBDBTransaction(), this.cursorConfig);
            if (cursor.getSearchBoth(keyEntry, valueEntry, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                cursor.delete();
            }
        }
        catch (Exception ex) {
            throw new HGException("Failed to lookup index '" + this.name + "': " + ex.toString(), ex);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    @Override
    public void removeAllEntries(KeyType key) {
        this.checkOpen();
        DatabaseEntry dbkey = new DatabaseEntry(this.keyConverter.toByteArray(key));
        try {
            this.db.delete(this.txn().getBDBTransaction(), dbkey);
        }
        catch (Exception ex) {
            throw new HGException("Failed to delete entry from index '" + this.name + "': " + ex.toString(), ex);
        }
    }

    void ping(Transaction tx) {
        DatabaseEntry key = new DatabaseEntry(new byte[1]);
        DatabaseEntry data = new DatabaseEntry();
        try {
            this.db.get(tx, key, data, LockMode.DEFAULT);
        }
        catch (Exception ex) {
            throw new HGException("Failed to ping index '" + this.name + "': " + ex.toString(), ex);
        }
    }

    @Override
    public ValueType findFirst(KeyType key) {
        this.checkOpen();
        DatabaseEntry keyEntry = new DatabaseEntry(this.keyConverter.toByteArray(key));
        DatabaseEntry value = new DatabaseEntry();
        ValueType result = null;
        Cursor cursor = null;
        try {
            cursor = this.db.openCursor(this.txn().getBDBTransaction(), this.cursorConfig);
            OperationStatus status = cursor.getSearchKey(keyEntry, value, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                result = this.valueConverter.fromByteArray(value.getData());
            }
        }
        catch (Exception ex) {
            throw new HGException("Failed to lookup index '" + this.name + "': " + ex.toString(), ex);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Throwable t) {}
            }
        }
        return result;
    }

    public ValueType findLast(KeyType key) {
        this.checkOpen();
        DatabaseEntry keyEntry = new DatabaseEntry(this.keyConverter.toByteArray(key));
        DatabaseEntry value = new DatabaseEntry();
        ValueType result = null;
        Cursor cursor = null;
        try {
            cursor = this.db.openCursor(this.txn().getBDBTransaction(), this.cursorConfig);
            OperationStatus status = cursor.getLast(keyEntry, value, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                result = this.valueConverter.fromByteArray(value.getData());
            }
        }
        catch (Exception ex) {
            throw new HGException("Failed to lookup index '" + this.name + "': " + ex.toString(), ex);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Throwable t) {}
            }
        }
        return result;
    }

    @Override
    public HGRandomAccessResult<ValueType> find(KeyType key) {
        HGRandomAccessResult<? extends Object> result;
        block8: {
            this.checkOpen();
            DatabaseEntry keyEntry = new DatabaseEntry(this.keyConverter.toByteArray(key));
            DatabaseEntry value = new DatabaseEntry();
            result = null;
            Cursor cursor = null;
            try {
                TransactionBDBImpl tx = this.txn();
                cursor = this.db.openCursor(this.txn().getBDBTransaction(), this.cursorConfig);
                OperationStatus status = cursor.getSearchKey(keyEntry, value, LockMode.DEFAULT);
                if (status == OperationStatus.SUCCESS && cursor.count() > 0) {
                    result = new SingleKeyResultSet<ValueType>(tx.attachCursor(cursor), keyEntry, this.valueConverter);
                    break block8;
                }
                try {
                    cursor.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                result = HGSearchResult.EMPTY;
            }
            catch (Throwable ex) {
                if (cursor != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                throw new HGException("Failed to lookup index '" + this.name + "': " + ex.toString(), ex);
            }
        }
        return result;
    }

    private HGSearchResult<ValueType> findOrdered(KeyType key, boolean lower_range, boolean compare_equals) {
        this.checkOpen();
        byte[] keyAsBytes = this.keyConverter.toByteArray(key);
        DatabaseEntry keyEntry = new DatabaseEntry(keyAsBytes);
        DatabaseEntry value = new DatabaseEntry();
        Cursor cursor = null;
        try {
            TransactionBDBImpl tx = this.txn();
            cursor = this.db.openCursor(this.txn().getBDBTransaction(), this.cursorConfig);
            OperationStatus status = cursor.getSearchKeyRange(keyEntry, value, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                Comparator comparator;
                Comparator comparator2 = comparator = this.db.getConfig().getType() == DatabaseType.BTREE ? this.db.getConfig().getBtreeComparator() : this.db.getConfig().getHashComparator();
                if (!compare_equals) {
                    if (lower_range) {
                        status = cursor.getPrev(keyEntry, value, LockMode.DEFAULT);
                    } else if (comparator.compare(keyAsBytes, keyEntry.getData()) == 0) {
                        status = cursor.getNextNoDup(keyEntry, value, LockMode.DEFAULT);
                    }
                } else if (lower_range && comparator.compare(keyAsBytes, keyEntry.getData()) != 0) {
                    status = cursor.getPrev(keyEntry, value, LockMode.DEFAULT);
                }
            } else {
                status = lower_range ? cursor.getLast(keyEntry, value, LockMode.DEFAULT) : cursor.getFirst(keyEntry, value, LockMode.DEFAULT);
            }
            if (status == OperationStatus.SUCCESS) {
                if (lower_range) {
                    return new SearchResultWrapper<ValueType>(new KeyRangeBackwardResultSet<ValueType>(tx.attachCursor(cursor), keyEntry, this.valueConverter));
                }
                return new SearchResultWrapper<ValueType>(new KeyRangeForwardResultSet<ValueType>(tx.attachCursor(cursor), keyEntry, this.valueConverter));
            }
            try {
                cursor.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            return HGSearchResult.EMPTY;
        }
        catch (Throwable ex) {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            throw new HGException("Failed to lookup index '" + this.name + "': " + ex.toString(), ex);
        }
    }

    @Override
    public HGSearchResult<ValueType> findGT(KeyType key) {
        return this.findOrdered(key, false, false);
    }

    @Override
    public HGSearchResult<ValueType> findGTE(KeyType key) {
        return this.findOrdered(key, false, true);
    }

    @Override
    public HGSearchResult<ValueType> findLT(KeyType key) {
        return this.findOrdered(key, true, false);
    }

    @Override
    public HGSearchResult<ValueType> findLTE(KeyType key) {
        return this.findOrdered(key, true, true);
    }

    protected void finalize() {
        if (this.isOpen()) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public long count() {
        try {
            return ((BtreeStats)this.db.getStats(this.txn().getBDBTransaction(), null)).getNumKeys();
        }
        catch (DatabaseException ex) {
            throw new HGException(ex);
        }
    }

    @Override
    public long count(KeyType key) {
        Cursor cursor = null;
        try {
            cursor = this.db.openCursor(this.txn().getBDBTransaction(), this.cursorConfig);
            DatabaseEntry keyEntry = new DatabaseEntry(this.keyConverter.toByteArray(key));
            DatabaseEntry value = new DatabaseEntry();
            OperationStatus status = cursor.getSearchKey(keyEntry, value, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                long l = cursor.count();
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (DatabaseException ex) {
            throw new HGException(ex);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Throwable t) {}
            }
        }
    }
}

