/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.storage;

import com.sleepycat.db.Cursor;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.SecondaryConfig;
import com.sleepycat.db.SecondaryCursor;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.db.SecondaryKeyCreator;
import java.util.Comparator;
import org.hypergraphdb.HGBidirectionalIndex;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGRandomAccessResult;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.storage.BDBStorageImplementation;
import org.hypergraphdb.storage.ByteArrayConverter;
import org.hypergraphdb.storage.DefaultIndexImpl;
import org.hypergraphdb.storage.PlainSecondaryKeyCreator;
import org.hypergraphdb.storage.SingleValueResultSet;
import org.hypergraphdb.transaction.HGTransactionManager;
import org.hypergraphdb.transaction.TransactionBDBImpl;

public class DefaultBiIndexImpl<KeyType, ValueType>
extends DefaultIndexImpl<KeyType, ValueType>
implements HGBidirectionalIndex<KeyType, ValueType> {
    private static final String SECONDARY_DB_NAME_PREFIX = "hgstore_idx__secondary";
    private DatabaseEntry dummy = new DatabaseEntry();
    private SecondaryDatabase secondaryDb = null;

    public DefaultBiIndexImpl(String indexName, BDBStorageImplementation storage, HGTransactionManager transactionManager, ByteArrayConverter<KeyType> keyConverter, ByteArrayConverter<ValueType> valueConverter, Comparator<?> comparator) {
        super(indexName, storage, transactionManager, keyConverter, valueConverter, comparator);
    }

    @Override
    public void open() {
        this.sort_duplicates = false;
        super.open();
        try {
            SecondaryConfig dbConfig = new SecondaryConfig();
            dbConfig.setAllowCreate(true);
            if (this.storage.getBerkleyEnvironment().getConfig().getTransactional()) {
                dbConfig.setTransactional(true);
                if (this.storage.getConfiguration().isStorageMVCC()) {
                    dbConfig.setMultiversion(true);
                }
            }
            dbConfig.setKeyCreator((SecondaryKeyCreator)PlainSecondaryKeyCreator.getInstance());
            dbConfig.setSortedDuplicates(true);
            dbConfig.setType(this.storage.getConfiguration().getDatabaseConfig().getType());
            this.secondaryDb = this.storage.getBerkleyEnvironment().openSecondaryDatabase(null, SECONDARY_DB_NAME_PREFIX + this.name, null, this.db, dbConfig);
        }
        catch (Throwable t) {
            throw new HGException("While attempting to open index ;" + this.name + "': " + t.toString(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HGException exception = null;
        try {
            super.close();
        }
        catch (HGException ex) {
            exception = ex;
        }
        if (this.secondaryDb == null) {
            return;
        }
        try {
            this.secondaryDb.close();
        }
        catch (Throwable t) {
            if (exception == null) {
                exception = new HGException(t);
            }
        }
        finally {
            this.secondaryDb = null;
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public boolean isOpen() {
        return super.isOpen() && this.secondaryDb != null;
    }

    @Override
    public void addEntry(KeyType key, ValueType value) {
        this.checkOpen();
        DatabaseEntry dbkey = new DatabaseEntry(this.keyConverter.toByteArray(key));
        DatabaseEntry dbvalue = new DatabaseEntry(this.valueConverter.toByteArray(value));
        try {
            OperationStatus result = this.db.put(this.txn().getBDBTransaction(), dbkey, dbvalue);
            if (result != OperationStatus.SUCCESS && result != OperationStatus.KEYEXIST) {
                throw new Exception("OperationStatus: " + result);
            }
        }
        catch (Exception ex) {
            throw new HGException("Failed to add entry to index '" + this.name + "': " + ex.toString(), ex);
        }
    }

    @Override
    public HGRandomAccessResult<KeyType> findByValue(ValueType value) {
        HGRandomAccessResult<? extends Object> result;
        block9: {
            if (!this.isOpen()) {
                throw new HGException("Attempting to lookup index '" + this.name + "' while it is closed.");
            }
            DatabaseEntry keyEntry = new DatabaseEntry(this.valueConverter.toByteArray(value));
            DatabaseEntry valueEntry = new DatabaseEntry();
            result = null;
            SecondaryCursor cursor = null;
            try {
                TransactionBDBImpl tx = this.txn();
                cursor = this.secondaryDb.openSecondaryCursor(tx.getBDBTransaction(), this.cursorConfig);
                OperationStatus status = cursor.getSearchKey(keyEntry, valueEntry, this.dummy, LockMode.DEFAULT);
                if (status == OperationStatus.SUCCESS && cursor.count() > 0) {
                    result = new SingleValueResultSet<Object>(tx.attachCursor((Cursor)cursor), keyEntry, this.keyConverter);
                    break block9;
                }
                try {
                    cursor.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                result = HGSearchResult.EMPTY;
            }
            catch (Exception ex) {
                if (cursor != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                throw new HGException("Failed to lookup index '" + this.name + "': " + ex.toString(), ex);
            }
        }
        return result;
    }

    @Override
    public KeyType findFirstByValue(ValueType value) {
        if (!this.isOpen()) {
            throw new HGException("Attempting to lookup by value index '" + this.name + "' while it is closed.");
        }
        DatabaseEntry keyEntry = new DatabaseEntry(this.valueConverter.toByteArray(value));
        DatabaseEntry valueEntry = new DatabaseEntry();
        KeyType result = null;
        SecondaryCursor cursor = null;
        try {
            cursor = this.secondaryDb.openSecondaryCursor(this.txn().getBDBTransaction(), this.cursorConfig);
            OperationStatus status = cursor.getSearchKey(keyEntry, valueEntry, this.dummy, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                result = (KeyType)this.keyConverter.fromByteArray(valueEntry.getData());
            }
        }
        catch (Exception ex) {
            throw new HGException("Failed to lookup index '" + this.name + "': " + ex.toString(), ex);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Throwable t) {}
            }
        }
        return result;
    }

    @Override
    public long countKeys(ValueType value) {
        DatabaseEntry keyEntry = new DatabaseEntry(this.valueConverter.toByteArray(value));
        DatabaseEntry valueEntry = new DatabaseEntry();
        SecondaryCursor cursor = null;
        try {
            cursor = this.secondaryDb.openSecondaryCursor(this.txn().getBDBTransaction(), this.cursorConfig);
            OperationStatus status = cursor.getSearchKey(keyEntry, valueEntry, this.dummy, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                long l = cursor.count();
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (DatabaseException ex) {
            throw new HGException(ex);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Throwable t) {}
            }
        }
    }
}

