/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.storage;

public class BAUtils {
    public static int readInt(byte[] buffer, int offset) {
        byte ch1 = buffer[offset];
        byte ch2 = buffer[offset + 1];
        byte ch3 = buffer[offset + 2];
        byte ch4 = buffer[offset + 3];
        return (ch1 & 0xFF) << 24 | (ch2 & 0xFF) << 16 | (ch3 & 0xFF) << 8 | ch4 & 0xFF;
    }

    public static void writeInt(int c, byte[] buffer, int offset) {
        buffer[offset + 0] = (byte)(c >>> 24 & 0xFF);
        buffer[offset + 1] = (byte)(c >>> 16 & 0xFF);
        buffer[offset + 2] = (byte)(c >>> 8 & 0xFF);
        buffer[offset + 3] = (byte)(c >>> 0 & 0xFF);
    }

    public static boolean eq(byte[] left, int leftPos, byte[] right, int rightPos, int size) {
        int i = leftPos;
        int j = rightPos;
        if (leftPos + size > left.length) {
            return false;
        }
        if (rightPos + size > right.length) {
            return false;
        }
        while (size > 0) {
            if (left[i++] != right[j++]) {
                return false;
            }
            --size;
        }
        return true;
    }

    public static int compare(byte[] left, int leftPos, byte[] right, int rightPos, int max) {
        int maxLeft = leftPos + max;
        int maxRight = rightPos + max;
        int i = leftPos;
        int j = rightPos;
        int comp = 0;
        while (comp == 0 && i < maxLeft && j < maxRight) {
            comp = left[i++] - right[j++];
        }
        return comp;
    }
}

