/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query.impl;

import java.util.NoSuchElementException;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.query.impl.RSCombiner;

public class SortedIntersectionResult<T>
implements HGSearchResult<T>,
RSCombiner<T> {
    private HGSearchResult<T> left;
    private HGSearchResult<T> right;
    private T current = null;
    private T next = null;
    private T prev = null;
    private int lookahead = 0;

    private T advance() {
        boolean advance_left = true;
        boolean advance_right = true;
        Comparable lnext = null;
        Comparable rnext = null;
        while (true) {
            int comp;
            if (advance_left) {
                if (!this.left.hasNext()) {
                    return null;
                }
                lnext = (Comparable)this.left.next();
            }
            if (advance_right) {
                if (!this.right.hasNext()) {
                    return null;
                }
                rnext = (Comparable)this.right.next();
            }
            if ((comp = lnext.compareTo(rnext)) == 0) {
                return (T)lnext;
            }
            if (comp < 0) {
                advance_left = true;
                advance_right = false;
                continue;
            }
            advance_left = false;
            advance_right = true;
        }
    }

    private T back() {
        boolean back_left = true;
        boolean back_right = true;
        Comparable lprev = null;
        Comparable rprev = null;
        while (true) {
            int comp;
            if (back_left) {
                if (!this.left.hasPrev()) {
                    return null;
                }
                lprev = (Comparable)this.left.prev();
            }
            if (back_right) {
                if (!this.right.hasPrev()) {
                    return null;
                }
                rprev = (Comparable)this.right.prev();
            }
            if ((comp = lprev.compareTo(rprev)) == 0) {
                return (T)lprev;
            }
            if (comp < 0) {
                back_left = false;
                back_right = true;
                continue;
            }
            back_left = false;
            back_right = true;
        }
    }

    public SortedIntersectionResult() {
    }

    public SortedIntersectionResult(HGSearchResult<T> left, HGSearchResult<T> right) {
        this.init(left, right);
    }

    @Override
    public void init(HGSearchResult<T> left, HGSearchResult<T> right) {
        this.left = left;
        this.right = right;
        this.next = this.advance();
        this.lookahead = 1;
    }

    @Override
    public T current() {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.current;
    }

    @Override
    public void close() {
        this.left.close();
        this.right.close();
    }

    @Override
    public boolean hasPrev() {
        return this.prev != null;
    }

    @Override
    public T prev() {
        if (this.prev == null) {
            throw new NoSuchElementException();
        }
        this.next = this.current;
        this.current = this.prev;
        ++this.lookahead;
        do {
            this.prev = this.back();
        } while (this.prev != null && --this.lookahead != -1);
        return this.current;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public T next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        this.prev = this.current;
        this.current = this.next;
        --this.lookahead;
        do {
            this.next = this.advance();
        } while (this.next != null && ++this.lookahead != 1);
        return this.current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOrdered() {
        return true;
    }
}

