/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query.impl;

import org.hypergraphdb.HGException;
import org.hypergraphdb.HGOrderedSearchable;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HGSearchable;
import org.hypergraphdb.query.ComparisonOperator;
import org.hypergraphdb.query.impl.KeyBasedQuery;

public class SearchableBasedQuery<Key, Value>
extends KeyBasedQuery<Key, Value> {
    protected HGSearchable<Key, Value> searchable;
    protected Key key;
    private ComparisonOperator operator = ComparisonOperator.EQ;

    public SearchableBasedQuery(HGSearchable<Key, Value> searchable, Key key, ComparisonOperator operator) {
        this.searchable = searchable;
        this.key = key;
        this.operator = operator;
    }

    @Override
    public HGSearchResult<Value> execute() {
        switch (this.operator) {
            case EQ: {
                return this.searchable.find(this.key);
            }
            case LT: {
                return ((HGOrderedSearchable)this.searchable).findLT(this.key);
            }
            case GT: {
                return ((HGOrderedSearchable)this.searchable).findGT(this.key);
            }
            case LTE: {
                return ((HGOrderedSearchable)this.searchable).findLTE(this.key);
            }
            case GTE: {
                return ((HGOrderedSearchable)this.searchable).findGTE(this.key);
            }
        }
        throw new HGException("Wrong operator code [" + (Object)((Object)this.operator) + "] passed to IndexBasedQuery.");
    }

    @Override
    public void setKey(Key key) {
        this.key = key;
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    public void setOperator(ComparisonOperator operator) {
        this.operator = operator;
    }

    public ComparisonOperator getOperator() {
        return this.operator;
    }

    public void setSearchable(HGSearchable<Key, Value> searchable) {
        this.searchable = searchable;
    }

    public HGSearchable<Key, Value> getSearchable() {
        return this.searchable;
    }
}

