/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query.impl;

import java.util.NoSuchElementException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.type.HGTypedValue;
import org.hypergraphdb.type.TypeUtils;

public class ProjectionAtomResultSet
implements HGSearchResult {
    private HyperGraph graph;
    private HGSearchResult searchResult;
    private HGHandle baseType = null;
    private String[] dimensionPath;
    private Object current = null;
    private int prevCount = 0;
    private int lookahead = 0;

    private Object examine(HGHandle h) {
        HGHandle ot = this.baseType == null ? this.graph.getTypeSystem().getTypeHandle(h) : this.baseType;
        HGTypedValue tv = TypeUtils.project(this.graph, ot, this.graph.get(h), this.dimensionPath, false);
        return tv != null ? this.graph.getHandle(tv.getValue()) : null;
    }

    public ProjectionAtomResultSet(HyperGraph graph, HGSearchResult searchResult, String[] dimensionPath, HGHandle baseType) {
        this.graph = graph;
        this.searchResult = searchResult;
        this.dimensionPath = dimensionPath;
        this.baseType = baseType;
    }

    @Override
    public void close() {
        this.searchResult.close();
    }

    public Object current() {
        return this.current;
    }

    @Override
    public boolean hasPrev() {
        return this.prevCount > 0;
    }

    @Override
    public Object prev() {
        if (this.prevCount == 0) {
            throw new NoSuchElementException();
        }
        while (this.lookahead > 0) {
            --this.lookahead;
            this.searchResult.prev();
        }
        --this.prevCount;
        while (this.searchResult.hasPrev() && this.examine((HGHandle)this.searchResult.prev()) == null) {
        }
        this.current = this.examine((HGHandle)this.searchResult.current());
        return this.current;
    }

    @Override
    public boolean hasNext() {
        if (this.lookahead > 0) {
            return this.examine((HGHandle)this.searchResult.current()) != null;
        }
        do {
            if (!this.searchResult.hasNext()) {
                return false;
            }
            ++this.lookahead;
        } while (this.examine((HGHandle)this.searchResult.next()) == null);
        return true;
    }

    @Override
    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.prevCount;
        this.lookahead = 0;
        this.current = this.examine((HGHandle)this.searchResult.current());
        return this.current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOrdered() {
        return this.searchResult.isOrdered();
    }
}

