/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query.impl;

import java.util.NoSuchElementException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGLink;
import org.hypergraphdb.HGSearchResult;

public class LinkTargetsResultSet
implements HGSearchResult<HGHandle> {
    private HGLink l = null;
    private int pos = -1;

    public LinkTargetsResultSet(HGLink l) {
        if (l == null) {
            throw new IllegalArgumentException("LinkTargetsResultSet with null link.");
        }
        this.l = l;
    }

    @Override
    public void close() {
    }

    @Override
    public HGHandle current() {
        if (this.pos < 0 || this.pos >= this.l.getArity()) {
            throw new NoSuchElementException();
        }
        return this.l.getTargetAt(this.pos);
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public boolean hasPrev() {
        return this.pos > 0;
    }

    @Override
    public HGHandle prev() {
        if (this.pos <= 0) {
            throw new NoSuchElementException();
        }
        return this.l.getTargetAt(--this.pos);
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.l.getArity() - 1;
    }

    @Override
    public HGHandle next() {
        if (this.pos >= this.l.getArity()) {
            throw new NoSuchElementException();
        }
        return this.l.getTargetAt(++this.pos);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

