/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query.impl;

import org.hypergraphdb.HGQuery;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.query.impl.RSCombiner;

public class IntersectionQuery
extends HGQuery {
    private HGQuery left;
    private HGQuery right;
    private RSCombiner combiner;

    public IntersectionQuery(HGQuery left, HGQuery right, RSCombiner combiner) {
        this.left = left;
        this.right = right;
        this.combiner = combiner;
    }

    public HGSearchResult execute() {
        HGSearchResult leftResult = this.left.execute();
        HGSearchResult rightResult = this.right.execute();
        if (!leftResult.hasNext() || !rightResult.hasNext()) {
            leftResult.close();
            rightResult.close();
            return HGSearchResult.EMPTY;
        }
        this.combiner.init(leftResult, rightResult);
        return this.combiner;
    }

    public HGQuery getLeft() {
        return this.left;
    }

    public void setLeft(HGQuery left) {
        this.left = left;
    }

    public HGQuery getRight() {
        return this.right;
    }

    public void setRight(HGQuery right) {
        this.right = right;
    }

    public RSCombiner getCombiner() {
        return this.combiner;
    }

    public void setCombiner(RSCombiner combiner) {
        this.combiner = combiner;
    }
}

