/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query.impl;

import org.hypergraphdb.HGException;
import org.hypergraphdb.HGIndex;
import org.hypergraphdb.HGQuery;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HGSortIndex;
import org.hypergraphdb.query.ComparisonOperator;

public class IndexBasedQuery
extends HGQuery<Object> {
    private HGIndex<? extends Object, ? extends Object> index;
    private Object key;
    private ComparisonOperator operator = ComparisonOperator.EQ;
    private ScanType scanType = ScanType.none;

    public IndexBasedQuery(HGIndex<Object, Object> index, ScanType scanType) {
        this.index = index;
        this.scanType = scanType;
    }

    public IndexBasedQuery(HGIndex<? extends Object, ? extends Object> index, Object key) {
        this.index = index;
        this.key = key;
    }

    public IndexBasedQuery(HGIndex<Object, Object> index, Object key, ComparisonOperator operator) {
        this.index = index;
        this.key = key;
        this.operator = operator;
    }

    @Override
    public HGSearchResult<Object> execute() {
        switch (this.scanType) {
            case keys: {
                return this.index.scanKeys();
            }
            case values: {
                this.index.scanValues();
            }
        }
        switch (this.operator) {
            case EQ: {
                return this.index.find(this.key);
            }
            case LT: {
                return ((HGSortIndex)this.index).findLT(this.key);
            }
            case GT: {
                return ((HGSortIndex)this.index).findGT(this.key);
            }
            case LTE: {
                return ((HGSortIndex)this.index).findLTE(this.key);
            }
            case GTE: {
                return ((HGSortIndex)this.index).findGTE(this.key);
            }
        }
        throw new HGException("Wrong operator code [" + (Object)((Object)this.operator) + "] passed to IndexBasedQuery.");
    }

    public static enum ScanType {
        none,
        keys,
        values;

    }
}

