/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query.impl;

import java.util.NoSuchElementException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.query.HGAtomPredicate;
import org.hypergraphdb.util.CloseMe;

public class FilteredResultSet<T>
implements HGSearchResult<T> {
    private HyperGraph hg;
    private HGSearchResult<T> searchResult;
    private HGAtomPredicate predicate;
    private T current = null;
    private int prevCount = -1;
    private int lookahead = 0;

    public FilteredResultSet(HyperGraph hg2, HGSearchResult<T> searchResult, HGAtomPredicate predicate, int lookahead) {
        this.hg = hg2;
        this.searchResult = searchResult;
        this.predicate = predicate;
        this.lookahead = lookahead;
    }

    @Override
    public void close() {
        this.searchResult.close();
        if (this.predicate instanceof CloseMe) {
            ((CloseMe)((Object)this.predicate)).close();
        }
    }

    @Override
    public T current() {
        return this.current;
    }

    @Override
    public boolean hasPrev() {
        return this.prevCount > 0;
    }

    @Override
    public T prev() {
        if (this.prevCount == 0) {
            throw new NoSuchElementException();
        }
        while (this.lookahead > 0) {
            --this.lookahead;
            this.searchResult.prev();
        }
        --this.prevCount;
        while (this.searchResult.hasPrev() && !this.predicate.satisfies(this.hg, (HGHandle)this.searchResult.prev())) {
        }
        this.current = this.searchResult.current();
        return this.current;
    }

    @Override
    public boolean hasNext() {
        if (this.lookahead > 0) {
            return this.predicate.satisfies(this.hg, (HGHandle)this.searchResult.current());
        }
        do {
            if (!this.searchResult.hasNext()) {
                return false;
            }
            ++this.lookahead;
        } while (!this.predicate.satisfies(this.hg, (HGHandle)this.searchResult.next()));
        return true;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.prevCount;
        this.lookahead = 0;
        this.current = this.searchResult.current();
        return this.current;
    }

    @Override
    public void remove() {
        while (this.lookahead > 0) {
            this.searchResult.prev();
            --this.lookahead;
        }
        this.searchResult.remove();
    }

    @Override
    public boolean isOrdered() {
        return this.searchResult.isOrdered();
    }
}

