/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query.cond2qry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGLink;
import org.hypergraphdb.HGOrderedSearchable;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGQuery;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HGSearchable;
import org.hypergraphdb.HGSortIndex;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.algorithms.DefaultALGenerator;
import org.hypergraphdb.algorithms.HGBreadthFirstTraversal;
import org.hypergraphdb.atom.HGSubsumes;
import org.hypergraphdb.query.And;
import org.hypergraphdb.query.AnyAtomCondition;
import org.hypergraphdb.query.AtomPartCondition;
import org.hypergraphdb.query.AtomProjectionCondition;
import org.hypergraphdb.query.AtomTypeCondition;
import org.hypergraphdb.query.AtomValueCondition;
import org.hypergraphdb.query.BFSCondition;
import org.hypergraphdb.query.ComparisonOperator;
import org.hypergraphdb.query.DFSCondition;
import org.hypergraphdb.query.HGAtomPredicate;
import org.hypergraphdb.query.HGQueryCondition;
import org.hypergraphdb.query.IncidentCondition;
import org.hypergraphdb.query.IndexCondition;
import org.hypergraphdb.query.IndexedPartCondition;
import org.hypergraphdb.query.LinkCondition;
import org.hypergraphdb.query.MapCondition;
import org.hypergraphdb.query.Nothing;
import org.hypergraphdb.query.Or;
import org.hypergraphdb.query.OrderedLinkCondition;
import org.hypergraphdb.query.SubsumedCondition;
import org.hypergraphdb.query.SubsumesCondition;
import org.hypergraphdb.query.TargetCondition;
import org.hypergraphdb.query.TypePlusCondition;
import org.hypergraphdb.query.TypedValueCondition;
import org.hypergraphdb.query.cond2qry.AndToQuery;
import org.hypergraphdb.query.cond2qry.ConditionToQuery;
import org.hypergraphdb.query.cond2qry.IncidentToQuery;
import org.hypergraphdb.query.cond2qry.LinkToQuery;
import org.hypergraphdb.query.cond2qry.QueryMetaData;
import org.hypergraphdb.query.cond2qry.ValueAsPredicateOnly;
import org.hypergraphdb.query.impl.HandleArrayResultSet;
import org.hypergraphdb.query.impl.IndexBasedQuery;
import org.hypergraphdb.query.impl.IndexScanQuery;
import org.hypergraphdb.query.impl.IntersectionQuery;
import org.hypergraphdb.query.impl.LinkTargetsResultSet;
import org.hypergraphdb.query.impl.PipeQuery;
import org.hypergraphdb.query.impl.PredicateBasedFilter;
import org.hypergraphdb.query.impl.ProjectionAtomResultSet;
import org.hypergraphdb.query.impl.ResultMapQuery;
import org.hypergraphdb.query.impl.SearchableBasedQuery;
import org.hypergraphdb.query.impl.SortedIntersectionResult;
import org.hypergraphdb.query.impl.TraversalBasedQuery;
import org.hypergraphdb.query.impl.UnionQuery;
import org.hypergraphdb.type.HGAtomType;

public class ToQueryMap
extends HashMap<Class<?>, ConditionToQuery> {
    private static final long serialVersionUID = -1L;
    private static final ToQueryMap instance = new ToQueryMap();

    public static ToQueryMap getInstance() {
        return instance;
    }

    static <ResultType> HGQuery<ResultType> toQuery(HyperGraph hg2, HGQueryCondition condition) {
        ConditionToQuery transformer = (ConditionToQuery)instance.get(condition.getClass());
        if (transformer == null) {
            throw new HGException("The query condition '" + condition + "' could not be translated to an executable query either because it is not specific enough. " + "Please try to contrain the query futher, for example by specifying the atom's types or " + "incidence sets or some indexed property value.");
        }
        HGQuery<?> q = transformer.getQuery(hg2, condition);
        q.setHyperGraph(hg2);
        return q;
    }

    static QueryMetaData toMetaData(HyperGraph hg2, HGQueryCondition condition) {
        ConditionToQuery transformer = (ConditionToQuery)instance.get(condition.getClass());
        if (transformer == null) {
            throw new HGException("The query condition '" + condition + "' could not be translated to an executable query because it is not specific enough. " + "Please try to contrain the query futher, for example by specifying the atom's types or " + "incidence sets or some indexed property value.");
        }
        return transformer.getMetaData(hg2, condition);
    }

    static {
        instance.put(Nothing.class, new ConditionToQuery(){

            @Override
            public HGQuery<?> getQuery(HyperGraph graph, HGQueryCondition c) {
                return HGQuery.NOP;
            }

            @Override
            public QueryMetaData getMetaData(HyperGraph hg2, HGQueryCondition c) {
                return QueryMetaData.EMPTY;
            }
        });
        instance.put(AnyAtomCondition.class, new ConditionToQuery(){

            @Override
            public HGQuery<?> getQuery(HyperGraph graph, HGQueryCondition c) {
                return new IndexScanQuery<HGPersistentHandle, HGPersistentHandle>(graph.getIndexManager().getIndexByType(), false);
            }

            @Override
            public QueryMetaData getMetaData(HyperGraph hg2, HGQueryCondition c) {
                QueryMetaData x = QueryMetaData.MISTERY.clone(c);
                x.predicateCost = 0.5;
                return x;
            }
        });
        instance.put(AtomTypeCondition.class, new ConditionToQuery(){

            private HGPersistentHandle getTypeHandle(HyperGraph graph, HGQueryCondition c) {
                AtomTypeCondition ac = (AtomTypeCondition)c;
                HGHandle h = ac.getTypeHandle();
                if (h == null) {
                    h = graph.getTypeSystem().getTypeHandle(ac.getJavaClass());
                }
                return graph.getPersistentHandle(h);
            }

            @Override
            public HGQuery<?> getQuery(HyperGraph graph, HGQueryCondition c) {
                return new SearchableBasedQuery<HGPersistentHandle, HGPersistentHandle>(graph.getIndexManager().getIndexByType(), this.getTypeHandle(graph, c), ComparisonOperator.EQ);
            }

            @Override
            public QueryMetaData getMetaData(HyperGraph graph, HGQueryCondition c) {
                QueryMetaData x = QueryMetaData.ORACCESS.clone(c);
                x.predicateCost = 1.0;
                x.sizeLB = x.sizeUB = graph.getIndexManager().getIndexByType().count(this.getTypeHandle(graph, c));
                x.sizeExpected = x.sizeUB;
                return x;
            }
        });
        instance.put(TypePlusCondition.class, new ConditionToQuery(){

            @Override
            public HGQuery<?> getQuery(HyperGraph hg2, HGQueryCondition c) {
                TypePlusCondition ac = (TypePlusCondition)c;
                Or orCondition = new Or();
                for (HGHandle h : ac.getSubTypes(hg2)) {
                    orCondition.add(new AtomTypeCondition(h));
                }
                return HGQuery.make(hg2, orCondition);
            }

            @Override
            public QueryMetaData getMetaData(HyperGraph hg2, HGQueryCondition c) {
                TypePlusCondition ac = (TypePlusCondition)c;
                Or orCondition = new Or();
                for (HGHandle h : ac.getSubTypes(hg2)) {
                    orCondition.add(new AtomTypeCondition(h));
                }
                return ToQueryMap.toMetaData(hg2, orCondition);
            }
        });
        instance.put(TypedValueCondition.class, new ConditionToQuery(){

            @Override
            public HGQuery<?> getQuery(HyperGraph hg2, HGQueryCondition c) {
                HGAtomType type;
                TypedValueCondition vc = (TypedValueCondition)c;
                Object value = vc.getValue();
                HGHandle typeHandle = vc.getTypeHandle();
                if (typeHandle == null) {
                    typeHandle = hg2.getTypeSystem().getTypeHandle(vc.getJavaClass());
                }
                if ((type = hg2.getTypeSystem().getType(typeHandle)) == null) {
                    throw new HGException("Cannot search by value " + value + " of unknown HGAtomType with handle " + typeHandle);
                }
                if (type instanceof HGSearchable && vc.getOperator() == ComparisonOperator.EQ || type instanceof HGOrderedSearchable) {
                    return new PredicateBasedFilter(hg2, new PipeQuery<Object, HGPersistentHandle>(new SearchableBasedQuery((HGSearchable)((Object)type), value, vc.getOperator()), new SearchableBasedQuery<Object, HGPersistentHandle>(hg2.getIndexManager().getIndexByValue(), null, ComparisonOperator.EQ)), new AtomTypeCondition(typeHandle));
                }
                return new PredicateBasedFilter(hg2, new IndexBasedQuery(hg2.getIndexManager().getIndexByType(), hg2.getPersistentHandle(typeHandle)), new AtomValueCondition(vc.getValue(), vc.getOperator()));
            }

            @Override
            public QueryMetaData getMetaData(HyperGraph hg2, HGQueryCondition c) {
                HGAtomType type;
                TypedValueCondition vc = (TypedValueCondition)c;
                HGHandle typeHandle = vc.getTypeHandle();
                if (typeHandle == null) {
                    typeHandle = hg2.getTypeSystem().getTypeHandle(vc.getJavaClass());
                }
                if ((type = hg2.getTypeSystem().getType(typeHandle)) == null) {
                    throw new HGException("Cannot search by value of unknown HGAtomType with handle " + typeHandle);
                }
                QueryMetaData qmd = type instanceof HGSearchable && vc.getOperator() == ComparisonOperator.EQ || type instanceof HGOrderedSearchable ? QueryMetaData.MISTERY.clone(c) : QueryMetaData.ORDERED.clone(c);
                qmd.predicateCost = 2.5;
                return qmd;
            }
        });
        instance.put(AtomValueCondition.class, new ConditionToQuery(){

            @Override
            public HGQuery<?> getQuery(HyperGraph hg2, HGQueryCondition c) {
                AtomValueCondition vc = (AtomValueCondition)c;
                Object value = vc.getValue();
                if (value == null) {
                    throw new HGException("Search by null values is not supported yet.");
                }
                HGHandle type = hg2.getTypeSystem().getTypeHandle(value);
                return ((ConditionToQuery)instance.get(TypedValueCondition.class)).getQuery(hg2, new TypedValueCondition(type, vc.getValue(), vc.getOperator()));
            }

            @Override
            public QueryMetaData getMetaData(HyperGraph hg2, HGQueryCondition c) {
                AtomValueCondition vc = (AtomValueCondition)c;
                Object value = vc.getValue();
                if (value == null) {
                    throw new HGException("Search by null values is not supported yet.");
                }
                HGHandle type = hg2.getTypeSystem().getTypeHandle(value);
                return ((ConditionToQuery)instance.get(TypedValueCondition.class)).getMetaData(hg2, new TypedValueCondition(type, vc.getValue(), vc.getOperator()));
            }
        });
        instance.put(ValueAsPredicateOnly.class, new ConditionToQuery(){

            @Override
            public HGQuery<?> getQuery(HyperGraph hg2, HGQueryCondition c) {
                return null;
            }

            @Override
            public QueryMetaData getMetaData(HyperGraph hg2, HGQueryCondition c) {
                QueryMetaData qmd = QueryMetaData.MISTERY.clone();
                qmd.predicateOnly = true;
                qmd.pred = (HGAtomPredicate)((Object)c);
                return qmd;
            }
        });
        instance.put(TargetCondition.class, new ConditionToQuery(){

            public HGQuery<HGHandle> getQuery(HyperGraph graph, HGQueryCondition c) {
                final HGPersistentHandle handle = graph.getPersistentHandle(((TargetCondition)c).getLink());
                return new HGQuery<HGHandle>(){

                    @Override
                    public HGSearchResult<HGHandle> execute() {
                        if (this.graph.isLoaded(handle)) {
                            return new LinkTargetsResultSet((HGLink)this.graph.get(handle));
                        }
                        HGHandle[] A = this.graph.getStore().getLink(handle);
                        if (A == null) {
                            throw new NullPointerException("No link data for handle " + handle);
                        }
                        return new HandleArrayResultSet(A, 2);
                    }
                };
            }

            @Override
            public QueryMetaData getMetaData(HyperGraph hg2, HGQueryCondition c) {
                QueryMetaData x = QueryMetaData.MISTERY.clone(c);
                x.predicateCost = 1.0;
                return x;
            }
        });
        instance.put(IncidentCondition.class, new IncidentToQuery());
        instance.put(LinkCondition.class, new LinkToQuery());
        instance.put(SubsumesCondition.class, new ConditionToQuery(){

            public HGQuery getQuery(HyperGraph hg2, HGQueryCondition c) {
                SubsumesCondition sc = (SubsumesCondition)c;
                HGHandle startAtom = sc.getSpecificHandle();
                if (startAtom == null && sc.getSpecificValue() != null && (startAtom = hg2.getHandle(sc.getSpecificValue())) == null) {
                    throw new HGException("Unable to translate 'subsumed' condition into a query since it is not based on an existing HyperGraph atom.");
                }
                return new TraversalBasedQuery(new HGBreadthFirstTraversal(startAtom, new DefaultALGenerator(hg2, new AtomTypeCondition(hg2.getTypeSystem().getTypeHandle(HGSubsumes.class)), null, false, true, true)), TraversalBasedQuery.ReturnType.targets);
            }

            @Override
            public QueryMetaData getMetaData(HyperGraph hg2, HGQueryCondition c) {
                QueryMetaData x = QueryMetaData.MISTERY.clone(c);
                x.predicateCost = 5.0;
                return x;
            }
        });
        instance.put(BFSCondition.class, new ConditionToQuery(){

            public HGQuery getQuery(HyperGraph graph, HGQueryCondition c) {
                BFSCondition cc = (BFSCondition)c;
                return new TraversalBasedQuery(cc.getTraversal(graph), TraversalBasedQuery.ReturnType.targets);
            }

            @Override
            public QueryMetaData getMetaData(HyperGraph hg2, HGQueryCondition c) {
                QueryMetaData x = QueryMetaData.MISTERY.clone(c);
                x.predicateCost = -1.0;
                x.predicateOnly = false;
                return x;
            }
        });
        instance.put(DFSCondition.class, new ConditionToQuery(){

            public HGQuery getQuery(HyperGraph graph, HGQueryCondition c) {
                DFSCondition cc = (DFSCondition)c;
                return new TraversalBasedQuery(cc.getTraversal(graph), TraversalBasedQuery.ReturnType.targets);
            }

            @Override
            public QueryMetaData getMetaData(HyperGraph hg2, HGQueryCondition c) {
                return QueryMetaData.MISTERY.clone(c);
            }
        });
        instance.put(SubsumedCondition.class, new ConditionToQuery(){

            public HGQuery getQuery(HyperGraph hg2, HGQueryCondition c) {
                SubsumedCondition sc = (SubsumedCondition)c;
                HGHandle startAtom = sc.getGeneralHandle();
                if (startAtom == null && sc.getGeneralValue() != null && (startAtom = hg2.getHandle(sc.getGeneralValue())) == null) {
                    throw new HGException("Unable to translate 'subsumed' condition into a query since it is not based on an existing HyperGraph atom.");
                }
                return new TraversalBasedQuery(new HGBreadthFirstTraversal(startAtom, new DefaultALGenerator(hg2, new AtomTypeCondition(hg2.getTypeSystem().getTypeHandle(HGSubsumes.class)), null, false, true, false)), TraversalBasedQuery.ReturnType.targets);
            }

            @Override
            public QueryMetaData getMetaData(HyperGraph hg2, HGQueryCondition c) {
                QueryMetaData x = QueryMetaData.MISTERY.clone(c);
                x.predicateCost = 5.0;
                return x;
            }
        });
        instance.put(OrderedLinkCondition.class, new ConditionToQuery(){

            public HGQuery getQuery(HyperGraph hg2, HGQueryCondition c) {
                OrderedLinkCondition lc = (OrderedLinkCondition)c;
                ArrayList L = new ArrayList();
                for (HGHandle t : lc.targets()) {
                    L.add(ToQueryMap.toQuery(hg2, new IncidentCondition(t)));
                }
                if (L.isEmpty()) {
                    return HGQuery.NOP;
                }
                if (L.size() == 1) {
                    return (HGQuery)L.get(0);
                }
                Iterator i = L.iterator();
                IntersectionQuery result = new IntersectionQuery((HGQuery)i.next(), (HGQuery)i.next(), new SortedIntersectionResult());
                while (i.hasNext()) {
                    result = new IntersectionQuery((HGQuery)i.next(), result, new SortedIntersectionResult());
                }
                return new PredicateBasedFilter(hg2, result, lc);
            }

            @Override
            public QueryMetaData getMetaData(HyperGraph hg2, HGQueryCondition c) {
                QueryMetaData qmd = ((OrderedLinkCondition)c).targets().length == 0 ? QueryMetaData.EMPTY.clone(c) : QueryMetaData.MISTERY.clone(c);
                qmd.predicateCost = 0.5;
                return qmd;
            }
        });
        instance.put(MapCondition.class, new ConditionToQuery(){

            public HGQuery getQuery(HyperGraph hg2, HGQueryCondition c) {
                MapCondition mc = (MapCondition)c;
                HGQuery query = ToQueryMap.toQuery(hg2, mc.getCondition());
                return new ResultMapQuery(query, mc.getMapping());
            }

            @Override
            public QueryMetaData getMetaData(HyperGraph hg2, HGQueryCondition c) {
                MapCondition mc = (MapCondition)c;
                QueryMetaData qmd = ((ConditionToQuery)instance.get(mc.getCondition().getClass())).getMetaData(hg2, mc.getCondition());
                qmd.randomAccess = false;
                qmd.ordered = false;
                qmd.predicateCost = -1.0;
                qmd.cond = c;
                return qmd;
            }
        });
        instance.put(IndexCondition.class, new ConditionToQuery(){

            @Override
            public HGQuery<?> getQuery(HyperGraph graph, HGQueryCondition c) {
                IndexCondition ic = (IndexCondition)c;
                if (ic.getOperator() != ComparisonOperator.EQ) {
                    if (!(ic.getIndex() instanceof HGSortIndex)) {
                        throw new IllegalArgumentException("Invalid operator : " + (Object)((Object)ic.getOperator()) + " for index " + ic.getIndex() + " and key " + ic.getKey());
                    }
                    return new IndexBasedQuery(ic.getIndex(), ic.getKey(), ic.getOperator());
                }
                return new IndexBasedQuery(ic.getIndex(), ic.getKey());
            }

            @Override
            public QueryMetaData getMetaData(HyperGraph hg2, HGQueryCondition c) {
                return QueryMetaData.ORACCESS.clone(c);
            }
        });
        instance.put(IndexedPartCondition.class, new ConditionToQuery(){

            @Override
            public HGQuery<?> getQuery(HyperGraph hg2, HGQueryCondition c) {
                IndexedPartCondition ip = (IndexedPartCondition)c;
                if (ip.getIndex() instanceof HGSortIndex) {
                    return new IndexBasedQuery((HGSortIndex)ip.getIndex(), ip.getPartValue(), ip.getOperator());
                }
                return new IndexBasedQuery(ip.getIndex(), ip.getPartValue());
            }

            @Override
            public QueryMetaData getMetaData(HyperGraph hg2, HGQueryCondition c) {
                return QueryMetaData.ORACCESS.clone(c);
            }
        });
        instance.put(And.class, new AndToQuery());
        instance.put(Or.class, new ConditionToQuery(){

            public HGQuery getQuery(HyperGraph hg2, HGQueryCondition c) {
                Or or = (Or)c;
                if (or.size() == 0) {
                    return HGQuery.NOP;
                }
                if (or.size() == 1) {
                    return ToQueryMap.toQuery(hg2, (HGQueryCondition)or.get(0));
                }
                HGQuery q1 = ToQueryMap.toQuery(hg2, (HGQueryCondition)or.get(0));
                if (q1 == null) {
                    throw new HGException("Untranslatable condition " + or.get(0));
                }
                HGQuery q2 = ToQueryMap.toQuery(hg2, (HGQueryCondition)or.get(1));
                if (q2 == null) {
                    throw new HGException("Untranslatable condition " + or.get(1));
                }
                UnionQuery result = new UnionQuery(q1, q2);
                for (int i = 2; i < or.size(); ++i) {
                    q1 = ToQueryMap.toQuery(hg2, (HGQueryCondition)or.get(i));
                    if (q1 == null) {
                        throw new HGException("Untranslatable condition " + or.get(i));
                    }
                    result = new UnionQuery(result, q1);
                }
                return result;
            }

            @Override
            public QueryMetaData getMetaData(HyperGraph hg2, HGQueryCondition c) {
                QueryMetaData x = QueryMetaData.ORACCESS.clone(c);
                boolean ispredicate = true;
                x.predicateCost = 0.0;
                for (HGQueryCondition sub : (Or)c) {
                    ConditionToQuery transformer;
                    if (!(sub instanceof HGAtomPredicate)) {
                        ispredicate = false;
                    }
                    if ((transformer = (ConditionToQuery)instance.get(sub.getClass())) == null) {
                        if (!(sub instanceof HGAtomPredicate)) {
                            throw new HGException("Condition " + sub + " is not query translatable, nor a predicate.");
                        }
                        x.ordered = false;
                        x.randomAccess = false;
                        continue;
                    }
                    QueryMetaData subx = transformer.getMetaData(hg2, sub);
                    ispredicate = ispredicate && subx.predicateCost > -1.0;
                    x.predicateCost += subx.predicateCost;
                    x.ordered = x.ordered && subx.ordered;
                    x.randomAccess = x.randomAccess && subx.randomAccess;
                }
                x.predicateCost = !ispredicate ? -1.0 : (x.predicateCost /= (double)((Or)c).size());
                return x;
            }
        });
        instance.put(AtomPartCondition.class, new ConditionToQuery(){

            public HGQuery getQuery(HyperGraph hg2, HGQueryCondition c) {
                return null;
            }

            @Override
            public QueryMetaData getMetaData(HyperGraph hg2, HGQueryCondition c) {
                QueryMetaData qmd = QueryMetaData.MISTERY.clone(c);
                qmd.predicateCost = 1.5;
                qmd.predicateOnly = true;
                return qmd;
            }
        });
        instance.put(AtomProjectionCondition.class, new ConditionToQuery(){

            public HGQuery getQuery(HyperGraph graph, HGQueryCondition c) {
                final AtomProjectionCondition apc = (AtomProjectionCondition)c;
                final HGQueryCondition bc = apc.getBaseSetCondition();
                HGHandle type = null;
                if (bc instanceof AtomTypeCondition) {
                    type = ((AtomTypeCondition)bc).getTypeHandle();
                }
                final HGHandle baseType = type;
                return new HGQuery(){

                    public HGSearchResult execute() {
                        HGQuery q = ToQueryMap.toQuery(this.graph, bc);
                        return new ProjectionAtomResultSet(this.graph, q.execute(), apc.getDimensionPath(), baseType);
                    }
                };
            }

            @Override
            public QueryMetaData getMetaData(HyperGraph hg2, HGQueryCondition c) {
                QueryMetaData x = QueryMetaData.MISTERY.clone(c);
                x.predicateCost = 100.0;
                return x;
            }
        });
    }
}

