/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query.cond2qry;

import org.hypergraphdb.query.HGAtomPredicate;
import org.hypergraphdb.query.HGQueryCondition;

class QueryMetaData
implements Cloneable {
    public static final QueryMetaData EMPTY = new QueryMetaData(true, true, 0L, 0L);
    public static final QueryMetaData MISTERY = new QueryMetaData(false, false);
    public static final QueryMetaData ORDERED = new QueryMetaData(true, false);
    public static final QueryMetaData RACCESS = new QueryMetaData(false, true);
    public static final QueryMetaData ORACCESS = new QueryMetaData(true, true);
    public HGQueryCondition cond;
    public HGAtomPredicate pred;
    public boolean ordered;
    public boolean randomAccess;
    public long sizeLB;
    public long sizeUB;
    public long sizeExpected;
    public double predicateCost = -1.0;
    public boolean predicateOnly = false;

    public QueryMetaData(boolean ordered, boolean randomAccess) {
        this.ordered = ordered;
        this.randomAccess = randomAccess;
        this.sizeLB = 0L;
        this.sizeUB = Long.MAX_VALUE;
        this.sizeExpected = -1L;
    }

    public QueryMetaData(boolean ordered, boolean randomAccess, double predicateCost) {
        this.ordered = ordered;
        this.randomAccess = randomAccess;
        this.predicateCost = predicateCost;
        this.sizeLB = 0L;
        this.sizeUB = Long.MAX_VALUE;
        this.sizeExpected = -1L;
    }

    public QueryMetaData(boolean ordered, boolean randomAccess, long sizeLB, long sizeUB) {
        this.ordered = ordered;
        this.randomAccess = randomAccess;
        this.sizeLB = sizeLB;
        this.sizeUB = sizeUB;
        this.sizeExpected = -1L;
    }

    public QueryMetaData(boolean ordered, boolean randomAccess, long sizeLB, long sizeUB, double predicateCost) {
        this.ordered = ordered;
        this.randomAccess = randomAccess;
        this.sizeLB = sizeLB;
        this.sizeUB = sizeUB;
        this.sizeExpected = -1L;
        this.predicateCost = predicateCost;
    }

    public QueryMetaData(boolean ordered, boolean randomAccess, long sizeLB, long sizeUB, long sizeExpected) {
        this.ordered = ordered;
        this.randomAccess = randomAccess;
        this.sizeLB = sizeLB;
        this.sizeUB = sizeUB;
        this.sizeExpected = sizeExpected;
    }

    public QueryMetaData(boolean ordered, boolean randomAccess, long sizeLB, long sizeUB, long sizeExpected, double predicateCost) {
        this.ordered = ordered;
        this.randomAccess = randomAccess;
        this.sizeLB = sizeLB;
        this.sizeUB = sizeUB;
        this.sizeExpected = sizeExpected;
        this.predicateCost = predicateCost;
    }

    public long getSizeExpected() {
        return this.sizeExpected < 0L ? (this.sizeUB - this.sizeLB) / 2L : this.sizeExpected;
    }

    public QueryMetaData clone() {
        return new QueryMetaData(this.ordered, this.randomAccess, this.sizeLB, this.sizeUB, this.sizeExpected, this.predicateCost);
    }

    public QueryMetaData clone(HGQueryCondition condition) {
        QueryMetaData cl = new QueryMetaData(this.ordered, this.randomAccess, this.sizeLB, this.sizeUB, this.sizeExpected, this.predicateCost);
        cl.cond = condition;
        if (condition instanceof HGAtomPredicate) {
            cl.pred = (HGAtomPredicate)((Object)condition);
        }
        return cl;
    }

    public QueryMetaData clone(HGAtomPredicate predicate) {
        QueryMetaData cl = new QueryMetaData(this.ordered, this.randomAccess, this.sizeLB, this.sizeUB, this.sizeExpected, this.predicateCost);
        cl.pred = predicate;
        if (predicate instanceof HGQueryCondition) {
            cl.cond = (HGQueryCondition)((Object)predicate);
        }
        return cl;
    }
}

