/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query.cond2qry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGQuery;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.query.And;
import org.hypergraphdb.query.HGAtomPredicate;
import org.hypergraphdb.query.HGQueryCondition;
import org.hypergraphdb.query.cond2qry.ConditionToQuery;
import org.hypergraphdb.query.cond2qry.QueryMetaData;
import org.hypergraphdb.query.cond2qry.ToQueryMap;
import org.hypergraphdb.query.impl.DelayedSetLoadPredicate;
import org.hypergraphdb.query.impl.IntersectionQuery;
import org.hypergraphdb.query.impl.PredicateBasedFilter;
import org.hypergraphdb.query.impl.RABasedPredicate;
import org.hypergraphdb.query.impl.SortedIntersectionResult;
import org.hypergraphdb.query.impl.ZigZagIntersectionResult;

public class AndToQuery
implements ConditionToQuery {
    private static BySizeComparator bySizeComparator = new BySizeComparator();

    @Override
    public QueryMetaData getMetaData(HyperGraph graph, HGQueryCondition condition) {
        QueryMetaData x = QueryMetaData.ORACCESS.clone(condition);
        boolean ispredicate = true;
        x.predicateCost = 0.0;
        for (HGQueryCondition sub : (And)condition) {
            ConditionToQuery transformer = (ConditionToQuery)ToQueryMap.getInstance().get(sub.getClass());
            if (transformer == null) {
                if (!(sub instanceof HGAtomPredicate)) {
                    throw new HGException("Condition " + sub + " is not query translatable, nor a predicate.");
                }
                x.ordered = false;
                x.randomAccess = false;
                continue;
            }
            QueryMetaData subx = transformer.getMetaData(graph, sub);
            ispredicate = ispredicate && subx.predicateCost > -1.0;
            x.predicateCost += subx.predicateCost;
            x.ordered = x.ordered && subx.ordered;
            x.randomAccess = x.randomAccess && subx.randomAccess;
        }
        if (!ispredicate) {
            x.predicateCost = -1.0;
        }
        return x;
    }

    @Override
    public HGQuery<?> getQuery(HyperGraph graph, HGQueryCondition condition) {
        Iterator i;
        And and = (And)condition;
        if (and.size() == 0) {
            return HGQuery.NOP;
        }
        if (and.size() == 1) {
            return ToQueryMap.toQuery(graph, (HGQueryCondition)and.iterator().next());
        }
        ArrayList<QueryMetaData> ORA = new ArrayList<QueryMetaData>();
        ArrayList<QueryMetaData> RA = new ArrayList<QueryMetaData>();
        ArrayList<QueryMetaData> O = new ArrayList<QueryMetaData>();
        ArrayList<QueryMetaData> P = new ArrayList<QueryMetaData>();
        ArrayList<QueryMetaData> W = new ArrayList<QueryMetaData>();
        for (HGQueryCondition sub : and) {
            QueryMetaData qmd;
            ConditionToQuery transformer = (ConditionToQuery)ToQueryMap.getInstance().get(sub.getClass());
            if (transformer == null) {
                qmd = QueryMetaData.MISTERY.clone(sub);
                qmd.predicateOnly = true;
                P.add(qmd);
                continue;
            }
            qmd = transformer.getMetaData(graph, sub);
            if (qmd.predicateOnly) {
                P.add(qmd);
                continue;
            }
            if (qmd.ordered && qmd.randomAccess) {
                ORA.add(qmd);
                continue;
            }
            if (qmd.ordered) {
                O.add(qmd);
                continue;
            }
            if (qmd.randomAccess) {
                RA.add(qmd);
                continue;
            }
            if (qmd.predicateCost > -1.0) {
                P.add(qmd);
                continue;
            }
            W.add(qmd);
        }
        HGQuery result = null;
        HGQueryCondition c1 = null;
        HGQueryCondition c2 = null;
        if (ORA.size() > 1) {
            Collections.sort(ORA, bySizeComparator);
            i = ORA.iterator();
            c1 = ((QueryMetaData)i.next()).cond;
            c2 = ((QueryMetaData)i.next()).cond;
            result = new IntersectionQuery(ToQueryMap.toQuery(graph, c1), ToQueryMap.toQuery(graph, c2), new ZigZagIntersectionResult());
            while (i.hasNext()) {
                c1 = ((QueryMetaData)i.next()).cond;
                result = new IntersectionQuery(result, ToQueryMap.toQuery(graph, c1), new ZigZagIntersectionResult());
            }
        } else if (ORA.size() == 1) {
            O.addAll(ORA);
            ORA.clear();
        }
        if (O.size() > 1) {
            Collections.sort(O, bySizeComparator);
            i = O.iterator();
            if (result == null) {
                c1 = ((QueryMetaData)i.next()).cond;
                c2 = ((QueryMetaData)i.next()).cond;
                result = new IntersectionQuery(ToQueryMap.toQuery(graph, c1), ToQueryMap.toQuery(graph, c2), new SortedIntersectionResult());
            }
            while (i.hasNext()) {
                c1 = ((QueryMetaData)i.next()).cond;
                result = new IntersectionQuery(result, ToQueryMap.toQuery(graph, c1), new SortedIntersectionResult());
            }
        } else if (O.size() == 1) {
            c1 = ((QueryMetaData)O.iterator().next()).cond;
            result = result == null ? ToQueryMap.toQuery(graph, c1) : new IntersectionQuery(result, ToQueryMap.toQuery(graph, c1), new SortedIntersectionResult());
        }
        if (result == null) {
            QueryMetaData curr;
            if (W.size() > 0) {
                i = W.iterator();
                long n = 0L;
                while (i.hasNext()) {
                    curr = (QueryMetaData)i.next();
                    if (n >= curr.getSizeExpected()) continue;
                    c1 = curr.cond;
                }
                result = ToQueryMap.toQuery(graph, c1);
                W.remove(c1);
            } else if (RA.size() > 0) {
                i = RA.iterator();
                double cost = 0.0;
                while (i.hasNext()) {
                    curr = (QueryMetaData)i.next();
                    if (!(cost < curr.predicateCost)) continue;
                    c1 = curr.cond;
                }
                result = ToQueryMap.toQuery(graph, c1);
                RA.remove(c1);
            } else if (P.size() > 0) {
                QueryMetaData found = null;
                for (QueryMetaData qmd : P) {
                    if (qmd.predicateOnly) continue;
                    found = qmd;
                    break;
                }
                if (found != null) {
                    result = ToQueryMap.toQuery(graph, found.cond);
                    P.remove(found);
                }
            }
            if (result == null) {
                throw new HGException("No query condition translatable into a scannable result set.");
            }
        }
        for (QueryMetaData curr : RA) {
            c1 = curr.cond;
            QueryMetaData pqmd = QueryMetaData.MISTERY.clone(new RABasedPredicate(ToQueryMap.toQuery(graph, c1)));
            pqmd.predicateCost = curr.predicateCost;
            P.add(pqmd);
        }
        while (!P.isEmpty()) {
            double predicateCost = Double.MAX_VALUE;
            QueryMetaData lessCostly = null;
            for (QueryMetaData curr : P) {
                if (!(curr.predicateCost < predicateCost)) continue;
                predicateCost = curr.predicateCost;
                lessCostly = curr;
            }
            result = new PredicateBasedFilter(graph, result, lessCostly.pred);
            P.remove(lessCostly);
        }
        for (QueryMetaData curr : W) {
            HGQuery<HGHandle> q = ToQueryMap.toQuery(graph, curr.cond);
            result = new PredicateBasedFilter(graph, result, new DelayedSetLoadPredicate(q));
        }
        return result;
    }

    private static class BySizeComparator
    implements Comparator<QueryMetaData> {
        private BySizeComparator() {
        }

        @Override
        public int compare(QueryMetaData o1, QueryMetaData o2) {
            long right;
            long left;
            long l = o1.sizeExpected > -1L ? o1.sizeExpected : (left = o1.sizeUB > -1L ? o1.sizeUB : o1.sizeLB);
            if (left == -1L) {
                return 0;
            }
            long l2 = o2.sizeExpected > -1L ? o2.sizeExpected : (right = o2.sizeUB > -1L ? o2.sizeUB : o2.sizeLB);
            if (right == -1L || left == right) {
                return 0;
            }
            if (left > right) {
                return 1;
            }
            return -1;
        }
    }
}

