/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query;

import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.query.AtomValueCondition;
import org.hypergraphdb.query.ComparisonOperator;
import org.hypergraphdb.util.HGUtils;

public class TypedValueCondition
extends AtomValueCondition {
    private Class<?> javaClass;
    private HGHandle typeHandle;

    public TypedValueCondition() {
    }

    public TypedValueCondition(HGHandle typeHandle, Object value) {
        this(typeHandle, value, ComparisonOperator.EQ);
    }

    public TypedValueCondition(Class<?> javaClass, Object value) {
        this(javaClass, value, ComparisonOperator.EQ);
    }

    public TypedValueCondition(HGHandle typeHandle, Object value, ComparisonOperator op) {
        super(value, op);
        this.typeHandle = typeHandle;
    }

    public TypedValueCondition(Class<?> javaClass, Object value, ComparisonOperator op) {
        super(value, op);
        this.javaClass = javaClass;
    }

    @Override
    public boolean satisfies(HyperGraph hg2, HGHandle handle) {
        Object atom = null;
        atom = hg2.get(handle);
        if (atom == null) {
            return false;
        }
        HGHandle type = hg2.getTypeSystem().getTypeHandle(handle);
        return type.equals(this.typeHandle) && this.compareToValue(hg2, atom);
    }

    public void setTypeHandle(HGHandle typeHandle) {
        this.typeHandle = typeHandle;
    }

    public HGHandle getTypeHandle() {
        return this.typeHandle;
    }

    public void setJavaClass(Class<?> javaClass) {
        this.javaClass = javaClass;
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer("valueIs(");
        result.append((Object)this.getOperator());
        result.append(",");
        result.append(String.valueOf(this.getValue()));
        result.append(" with type ");
        result.append(this.typeHandle);
        result.append(")");
        return result.toString();
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.javaClass == null ? this.typeHandle.hashCode() : this.javaClass.hashCode());
    }

    @Override
    public boolean equals(Object x) {
        if (!(x instanceof TypedValueCondition)) {
            return false;
        }
        TypedValueCondition c = (TypedValueCondition)x;
        return (this.javaClass == null ? HGUtils.eq(this.typeHandle, c.typeHandle) : HGUtils.eq(this.javaClass, c.javaClass)) && super.equals(x);
    }
}

