/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query;

import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.algorithms.DefaultALGenerator;
import org.hypergraphdb.algorithms.HGALGenerator;
import org.hypergraphdb.algorithms.HGTraversal;
import org.hypergraphdb.query.HGAtomPredicate;
import org.hypergraphdb.query.HGQueryCondition;
import org.hypergraphdb.query.TypePlusCondition;
import org.hypergraphdb.util.HGUtils;

public abstract class TraversalCondition
implements HGQueryCondition {
    private HGHandle startAtom;
    private HGAtomPredicate linkPredicate = null;
    private HGAtomPredicate siblingPredicate = null;
    private boolean returnPreceeding = true;
    private boolean returnSucceeding = true;
    private boolean reverseOrder = false;
    private boolean returnSource = false;

    public TraversalCondition() {
    }

    public TraversalCondition(HGHandle startAtom) {
        this.startAtom = startAtom;
    }

    public HGALGenerator makeGenerator(HyperGraph graph) {
        return new DefaultALGenerator(graph, this.linkPredicate, this.siblingPredicate, this.returnPreceeding, this.returnSucceeding, this.reverseOrder, this.returnSource);
    }

    public abstract HGTraversal getTraversal(HyperGraph var1);

    public HGHandle getStartAtom() {
        return this.startAtom;
    }

    public void setStartAtom(HGHandle startAtom) {
        this.startAtom = startAtom;
    }

    public HGAtomPredicate getLinkPredicate() {
        return this.linkPredicate;
    }

    public void setLinkPredicate(HGAtomPredicate linkPredicate) {
        this.linkPredicate = linkPredicate;
    }

    public HGAtomPredicate getSiblingPredicate() {
        return this.siblingPredicate;
    }

    public void setSiblingPredicate(HGAtomPredicate siblingPredicate) {
        this.siblingPredicate = siblingPredicate;
    }

    public boolean isReturnPreceeding() {
        return this.returnPreceeding;
    }

    public void setReturnPreceeding(boolean returnPreceeding) {
        this.returnPreceeding = returnPreceeding;
    }

    public boolean isReturnSucceeding() {
        return this.returnSucceeding;
    }

    public void setReturnSucceeding(boolean returnSucceeding) {
        this.returnSucceeding = returnSucceeding;
    }

    public boolean isReverseOrder() {
        return this.reverseOrder;
    }

    public void setReverseOrder(boolean reverseOrder) {
        this.reverseOrder = reverseOrder;
    }

    public boolean isReturnSource() {
        return this.returnSource;
    }

    public void setReturnSource(boolean returnSource) {
        this.returnSource = returnSource;
    }

    public int hashCode() {
        return HGUtils.hashThem(this.startAtom, HGUtils.hashThem(this.linkPredicate, HGUtils.hashThem(this.siblingPredicate, this.reverseOrder)));
    }

    public boolean equals(Object x) {
        if (!(x instanceof TypePlusCondition)) {
            return false;
        }
        TraversalCondition c = (TraversalCondition)x;
        return this.startAtom.equals(c.startAtom) && HGUtils.eq(this.linkPredicate, c.linkPredicate) && HGUtils.eq(this.siblingPredicate, c.siblingPredicate) && this.returnSucceeding == c.returnSucceeding && this.returnPreceeding == c.returnPreceeding && this.returnSource == c.returnSource && this.reverseOrder == c.reverseOrder;
    }
}

