/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query;

import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.query.HGAtomPredicate;
import org.hypergraphdb.query.HGQueryCondition;
import org.hypergraphdb.query.SubsumesImpl;
import org.hypergraphdb.type.HGAtomType;

public class SubsumedCondition
extends SubsumesImpl
implements HGQueryCondition,
HGAtomPredicate {
    private HGHandle general;
    private Object generalValue;
    private HGAtomPredicate impl;

    public SubsumedCondition() {
    }

    public SubsumedCondition(Object generalValue) {
        this.setGeneralValue(generalValue);
    }

    public SubsumedCondition(HGHandle general) {
        this.setGeneralHandle(general);
    }

    public HGHandle getGeneralHandle() {
        return this.general;
    }

    public void setGeneralHandle(HGHandle general) {
        this.general = general;
        if (this.general != null) {
            this.impl = new HandleBased();
        }
    }

    public Object getGeneralValue() {
        return this.generalValue;
    }

    public void setGeneralValue(Object generalValue) {
        this.generalValue = generalValue;
        if (generalValue != null) {
            this.impl = new AtomBased();
        }
    }

    @Override
    public final boolean satisfies(HyperGraph hg2, HGHandle specific) {
        return this.impl.satisfies(hg2, specific);
    }

    public int hashCode() {
        return this.general != null ? this.general.hashCode() : this.generalValue.hashCode();
    }

    public boolean equals(Object x) {
        if (!(x instanceof SubsumedCondition)) {
            return false;
        }
        SubsumedCondition c = (SubsumedCondition)x;
        return this.general.equals(c.general);
    }

    private final class HandleBased
    implements HGAtomPredicate {
        private HandleBased() {
        }

        @Override
        public boolean satisfies(HyperGraph hg2, HGHandle specific) {
            if (SubsumedCondition.this.declaredSubsumption(hg2, SubsumedCondition.this.general, specific)) {
                return true;
            }
            HGHandle specificType = hg2.getType(specific);
            HGHandle generalType = hg2.getType(SubsumedCondition.this.general);
            if (!generalType.equals(specificType)) {
                return false;
            }
            return ((HGAtomType)hg2.get(generalType)).subsumes(hg2.get(SubsumedCondition.this.general), hg2.get(specific));
        }
    }

    private final class AtomBased
    implements HGAtomPredicate {
        private AtomBased() {
        }

        @Override
        public boolean satisfies(HyperGraph hg2, HGHandle specific) {
            HGHandle generalType;
            HGHandle specificType = hg2.getType(specific);
            if (SubsumedCondition.this.generalValue == null) {
                return ((HGAtomType)hg2.get(hg2.getType(specific))).subsumes(null, hg2.get(specific));
            }
            HGHandle h = hg2.getHandle(SubsumedCondition.this.generalValue);
            if (h == null) {
                generalType = hg2.getTypeSystem().getTypeHandle(SubsumedCondition.this.generalValue.getClass());
            } else {
                generalType = hg2.getType(h);
                if (SubsumedCondition.this.declaredSubsumption(hg2, h, specific)) {
                    return true;
                }
            }
            if (!generalType.equals(specificType)) {
                return false;
            }
            return ((HGAtomType)hg2.get(hg2.getType(specific))).subsumes(SubsumedCondition.this.generalValue, hg2.get(specific));
        }
    }
}

