/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query;

import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.query.HGAtomPredicate;
import org.hypergraphdb.query.HGQueryCondition;

public class IncidentCondition
implements HGQueryCondition,
HGAtomPredicate {
    private HGHandle target;

    public IncidentCondition() {
    }

    public IncidentCondition(HGHandle target) {
        this.target = target;
    }

    public HGHandle getTarget() {
        return this.target;
    }

    public void setTarget(HGHandle target) {
        this.target = target;
    }

    @Override
    public boolean satisfies(HyperGraph hg2, HGHandle handle) {
        HGPersistentHandle targetPHandle = hg2.getPersistentHandle(this.target);
        HGPersistentHandle[] targetSet = hg2.getStore().getLink(hg2.getPersistentHandle(handle));
        for (int i = 2; i < targetSet.length; ++i) {
            if (!targetPHandle.equals(targetSet[i])) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public boolean equals(Object x) {
        if (!(x instanceof IncidentCondition)) {
            return false;
        }
        return ((IncidentCondition)x).target.equals(this.target);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("linksTo(");
        result.append(this.target);
        result.append(")");
        return result.toString();
    }
}

