/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query;

import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.query.HGAtomPredicate;
import org.hypergraphdb.query.HGQueryCondition;
import org.hypergraphdb.util.HGUtils;

public class AtomTypeCondition
implements HGQueryCondition,
HGAtomPredicate {
    private Class<?> c;
    private HGHandle handle;

    public AtomTypeCondition() {
    }

    public AtomTypeCondition(Class<?> javaClass) {
        if (javaClass == null) {
            throw new NullPointerException();
        }
        this.c = javaClass;
    }

    public AtomTypeCondition(HGHandle typeHandle) {
        if (typeHandle == null) {
            throw new NullPointerException("Type handle is null.");
        }
        this.handle = typeHandle;
    }

    public void setJavaClass(Class<?> c) {
        this.c = c;
    }

    public Class<?> getJavaClass() {
        return this.c;
    }

    public void setTypeHandle(HGHandle handle) {
        this.handle = handle;
    }

    public HGHandle getTypeHandle() {
        return this.handle;
    }

    @Override
    public boolean satisfies(HyperGraph hg2, HGHandle value) {
        HGHandle typeOfValue;
        HGHandle h = this.handle;
        if (h == null) {
            h = hg2.getTypeSystem().getTypeHandle(this.c);
        }
        if ((typeOfValue = hg2.getType(value)) == null) {
            throw new HGException("Could not get type of atom " + value);
        }
        return typeOfValue.equals(h);
    }

    public int hashCode() {
        return this.c == null ? this.handle.hashCode() : this.c.hashCode();
    }

    public boolean equals(Object x) {
        if (!(x instanceof AtomTypeCondition)) {
            return false;
        }
        AtomTypeCondition cond = (AtomTypeCondition)x;
        return this.c == null ? HGUtils.eq(this.handle, cond.handle) : HGUtils.eq(this.c, cond.c);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("typeIs(");
        result.append(this.c != null ? this.c.getName() : this.handle);
        result.append(")");
        return result.toString();
    }
}

