/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query;

import java.util.HashMap;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.query.HGAtomPredicate;
import org.hypergraphdb.query.HGQueryCondition;
import org.hypergraphdb.type.HGAtomType;
import org.hypergraphdb.type.HGProjection;
import org.hypergraphdb.type.TypeUtils;
import org.hypergraphdb.util.HGUtils;

public class AtomProjectionCondition
implements HGQueryCondition,
HGAtomPredicate {
    private String[] dimensionPath;
    private HGQueryCondition baseSetCondition;
    private HashMap<HGHandle, HGHandle> baseSet = null;

    public AtomProjectionCondition() {
    }

    public AtomProjectionCondition(String dimensionPath, HGQueryCondition baseSetCondition) {
        this.dimensionPath = TypeUtils.parseDimensionPath(dimensionPath);
        this.baseSetCondition = baseSetCondition;
    }

    public AtomProjectionCondition(String[] dimensionPath, HGQueryCondition baseSetCondition) {
        this.dimensionPath = dimensionPath;
        this.baseSetCondition = baseSetCondition;
    }

    public String[] getDimensionPath() {
        return this.dimensionPath;
    }

    public HGQueryCondition getBaseSetCondition() {
        return this.baseSetCondition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean satisfies(HyperGraph graph, HGHandle handle) {
        if (this.baseSet == null) {
            this.baseSet = new HashMap();
            HGSearchResult rs = null;
            try {
                rs = graph.find(this.baseSetCondition);
                while (rs.hasNext()) {
                    Object part;
                    HGHandle h = (HGHandle)rs.next();
                    HGAtomType ot = graph.getTypeSystem().getAtomType(h);
                    HGProjection proj = TypeUtils.getProjection(graph, ot, this.dimensionPath);
                    if (proj == null || (part = proj.project(graph.get(h))) == null) continue;
                    this.baseSet.put(graph.getHandle(part), h);
                }
            }
            finally {
                HGUtils.closeNoException(rs);
            }
        }
        return this.baseSet.containsKey(handle);
    }

    public int hashCode() {
        return HGUtils.hashThem(this.dimensionPath, this.baseSetCondition);
    }

    public boolean equals(Object x) {
        if (!(x instanceof AtomProjectionCondition)) {
            return false;
        }
        AtomProjectionCondition c = (AtomProjectionCondition)x;
        return HGUtils.eq(this.dimensionPath, c.dimensionPath) && HGUtils.eq(this.baseSetCondition, c.baseSetCondition);
    }

    public void setDimensionPath(String[] dimensionPath) {
        this.dimensionPath = dimensionPath;
    }

    public void setBaseSetCondition(HGQueryCondition baseSetCondition) {
        this.baseSetCondition = baseSetCondition;
    }
}

