/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query;

import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.query.ComparisonOperator;
import org.hypergraphdb.query.SimpleValueCondition;
import org.hypergraphdb.type.HGTypedValue;
import org.hypergraphdb.type.TypeUtils;
import org.hypergraphdb.util.HGUtils;

public class AtomPartCondition
extends SimpleValueCondition {
    private String[] dimensionPath;

    public AtomPartCondition() {
        super(null, ComparisonOperator.EQ);
    }

    public AtomPartCondition(String[] dimensionPath, Object value) {
        this(dimensionPath, value, ComparisonOperator.EQ);
    }

    public AtomPartCondition(String[] dimensionPath, Object value, ComparisonOperator operator) {
        super(value, operator);
        this.dimensionPath = dimensionPath;
    }

    public String[] getDimensionPath() {
        return this.dimensionPath;
    }

    public void setDimensionPath(String[] dimensionPath) {
        this.dimensionPath = dimensionPath;
    }

    @Override
    public boolean satisfies(HyperGraph hg2, HGHandle handle) {
        Object atom = null;
        atom = hg2.get(handle);
        if (atom == null) {
            return false;
        }
        HGHandle type = hg2.getTypeSystem().getTypeHandle(handle);
        HGTypedValue projected = TypeUtils.project(hg2, type, atom, this.dimensionPath, false);
        if (projected != null) {
            return this.compareToValue(hg2, projected.getValue());
        }
        return false;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("valufOf(");
        for (int i = 0; i < this.dimensionPath.length; ++i) {
            result.append(this.dimensionPath[i]);
            if (i + 1 >= this.dimensionPath.length) continue;
            result.append(".");
        }
        result.append(", ");
        result.append((Object)this.getOperator());
        result.append(",");
        result.append(String.valueOf(this.getValue()));
        result.append(")");
        return result.toString();
    }

    @Override
    public int hashCode() {
        return HGUtils.hashThem(this.dimensionPath, HGUtils.hashThem(this.value, (Object)this.operator));
    }

    @Override
    public boolean equals(Object x) {
        if (!(x instanceof AtomPartCondition)) {
            return false;
        }
        AtomPartCondition c = (AtomPartCondition)x;
        return HGUtils.eq((Object)this.operator, (Object)c.operator) && HGUtils.eq(this.value, c.value) && HGUtils.eq(this.dimensionPath, c.dimensionPath);
    }
}

