/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query;

import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGLink;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.query.HGAtomPredicate;
import org.hypergraphdb.query.HGQueryCondition;

public class ArityCondition
implements HGQueryCondition,
HGAtomPredicate {
    private int arity;

    public ArityCondition() {
        this.arity = 0;
    }

    public ArityCondition(int arity) {
        this.arity = arity;
    }

    @Override
    public boolean satisfies(HyperGraph hg2, HGHandle handle) {
        if (hg2.isLoaded(handle)) {
            Object atom = hg2.get(handle);
            if (!(atom instanceof HGLink)) {
                return this.arity == 0;
            }
            return ((HGLink)atom).getArity() == this.arity;
        }
        HGPersistentHandle[] layout = hg2.getStore().getLink(hg2.getPersistentHandle(handle));
        if (layout == null) {
            throw new HGException("Cound not find atom refered to by " + handle + " in HyperGraph store.");
        }
        return layout.length == this.arity + 2;
    }

    public int hashCode() {
        return this.arity;
    }

    public boolean equals(Object x) {
        if (!(x instanceof ArityCondition)) {
            return false;
        }
        return this.arity == ((ArityCondition)x).arity;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("arity(");
        result.append(String.valueOf(this.arity));
        result.append(")");
        return result.toString();
    }

    public int getArity() {
        return this.arity;
    }

    public void setArity(int arity) {
        this.arity = arity;
    }
}

