/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.xmpp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Future;
import org.hypergraphdb.peer.HGPeerIdentity;
import org.hypergraphdb.peer.HyperGraphPeer;
import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.MessageHandler;
import org.hypergraphdb.peer.NetworkPeerPresenceListener;
import org.hypergraphdb.peer.PeerFilter;
import org.hypergraphdb.peer.PeerFilterEvaluator;
import org.hypergraphdb.peer.PeerInterface;
import org.hypergraphdb.peer.PeerRelatedActivity;
import org.hypergraphdb.peer.PeerRelatedActivityFactory;
import org.hypergraphdb.peer.Structs;
import org.hypergraphdb.peer.protocol.Protocol;
import org.hypergraphdb.util.CompletedFuture;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.filetransfer.FileTransferListener;
import org.jivesoftware.smackx.filetransfer.FileTransferManager;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.IncomingFileTransfer;
import org.jivesoftware.smackx.filetransfer.OutgoingFileTransfer;
import org.jivesoftware.smackx.muc.DefaultParticipantStatusListener;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;

public class XMPPPeerInterface
implements PeerInterface {
    private String serverName;
    private Number port;
    private String user;
    private String password;
    private String roomId;
    private boolean ignoreRoster = false;
    private boolean anonymous;
    private boolean autoRegister;
    private int fileTransferThreshold;
    private HyperGraphPeer thisPeer;
    private ArrayList<NetworkPeerPresenceListener> presenceListeners = new ArrayList();
    private MessageHandler messageHandler;
    ConnectionConfiguration config = null;
    XMPPConnection connection;
    MultiUserChat room = null;
    FileTransferManager fileTransfer;

    @Override
    public void configure(Map<String, Object> configuration) {
        this.serverName = (String)Structs.getPart(configuration, "serverUrl");
        this.port = Structs.getOptPart(configuration, 5222, "port");
        this.user = (String)Structs.getPart(configuration, "user");
        this.password = (String)Structs.getPart(configuration, "password");
        this.roomId = Structs.getOptPart(configuration, null, "room");
        this.ignoreRoster = Structs.getOptPart(configuration, false, "ignoreRoster");
        this.autoRegister = Structs.getOptPart(configuration, false, "autoRegister");
        this.anonymous = Structs.getOptPart(configuration, false, "anonymous");
        this.fileTransferThreshold = Structs.getOptPart(configuration, 102400, "fileTransferThreshold");
        this.config = new ConnectionConfiguration(this.serverName, this.port.intValue());
        this.config.setRosterLoadedAtLogin(true);
        this.config.setReconnectionAllowed(true);
        SmackConfiguration.setPacketReplyTimeout((int)30000);
    }

    private void reconnect() {
        if (this.connection != null && this.connection.isConnected()) {
            this.stop();
        }
        this.start();
    }

    private void processPeerJoin(String name) {
        for (NetworkPeerPresenceListener listener : this.presenceListeners) {
            listener.peerJoined(name);
        }
    }

    private void processPeerLeft(String name) {
        for (NetworkPeerPresenceListener listener : this.presenceListeners) {
            listener.peerLeft(name);
        }
    }

    private void processMessage(org.jivesoftware.smack.packet.Message msg) {
        Message M = null;
        if (this.thisPeer != null) {
            this.thisPeer.getGraph().getTransactionManager().beginTransaction();
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(StringUtils.decodeBase64((String)msg.getBody()));
            M = new Message(new Protocol().readMessage(in));
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
        finally {
            try {
                if (this.thisPeer != null) {
                    this.thisPeer.getGraph().getTransactionManager().endTransaction(false);
                }
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
        this.messageHandler.handleMessage(M);
    }

    private void initPacketListener() {
        this.connection.addPacketListener(new PacketListener(){

            private void handlePresence(Presence presence) {
                String user = presence.getFrom();
                Roster roster = XMPPPeerInterface.this.connection.getRoster();
                String n = this.makeRosterName(user);
                if (XMPPPeerInterface.this.connection.getUser().equals(n)) {
                    return;
                }
                if (roster.getEntry(n) == null && presence.getType() != Presence.Type.unavailable) {
                    return;
                }
                if (presence.getType() == Presence.Type.subscribe) {
                    Presence reply = new Presence(Presence.Type.subscribed);
                    reply.setTo(presence.getFrom());
                    XMPPPeerInterface.this.connection.sendPacket((Packet)reply);
                } else if (presence.getType() == Presence.Type.available) {
                    XMPPPeerInterface.this.processPeerJoin(user);
                } else if (presence.getType() == Presence.Type.unavailable) {
                    XMPPPeerInterface.this.processPeerLeft(user);
                }
            }

            private String makeRosterName(String name) {
                if (name.indexOf(47) < 0) {
                    return name;
                }
                String first = name.substring(0, name.indexOf(47));
                String second = name.substring(name.indexOf(47) + 1);
                if (second.length() != 36) {
                    return second + "@" + XMPPPeerInterface.this.connection.getServiceName();
                }
                try {
                    XMPPPeerInterface.this.thisPeer.getGraph().getHandleFactory().makeHandle(second);
                    return first;
                }
                catch (NumberFormatException ex) {
                    return second;
                }
            }

            public void processPacket(Packet packet) {
                if (packet instanceof Presence) {
                    if (!XMPPPeerInterface.this.ignoreRoster) {
                        this.handlePresence((Presence)packet);
                    }
                    return;
                }
                XMPPPeerInterface.this.processMessage((org.jivesoftware.smack.packet.Message)packet);
            }
        }, new PacketFilter(){

            public boolean accept(Packet p) {
                if (p instanceof Presence) {
                    return true;
                }
                if (!(p instanceof org.jivesoftware.smack.packet.Message)) {
                    return false;
                }
                org.jivesoftware.smack.packet.Message msg = (org.jivesoftware.smack.packet.Message)p;
                if (!msg.getType().equals((Object)Message.Type.normal)) {
                    return false;
                }
                Boolean hgprop = (Boolean)msg.getProperty("hypergraphdb");
                return hgprop != null && hgprop != false;
            }
        });
    }

    private String roomJidToUser(String jid) {
        String[] A = jid.split("/");
        return A[1] + "@" + this.connection.getServiceName();
    }

    private void initRoomConnectivity() {
        this.room = new MultiUserChat(this.getConnection(), this.roomId);
        this.room.addParticipantStatusListener((ParticipantStatusListener)new DefaultParticipantStatusListener(){

            public void joined(String participant) {
                XMPPPeerInterface.this.processPeerJoin(XMPPPeerInterface.this.roomJidToUser(participant));
            }

            public void kicked(String participant, String actor, String reason) {
                XMPPPeerInterface.this.processPeerLeft(XMPPPeerInterface.this.roomJidToUser(participant));
            }

            public void left(String participant) {
                XMPPPeerInterface.this.processPeerLeft(XMPPPeerInterface.this.roomJidToUser(participant));
            }
        });
    }

    private void login() throws XMPPException {
        if (this.anonymous) {
            this.connection.loginAnonymously();
        } else {
            try {
                this.connection.login(this.user, this.password, this.thisPeer != null ? this.thisPeer.getIdentity().getId().toString() : null);
            }
            catch (XMPPException ex) {
                if (ex.getMessage().indexOf("authentication failed") > -1 && this.autoRegister && this.connection.getAccountManager().supportsAccountCreation()) {
                    this.connection.getAccountManager().createAccount(this.user, this.password);
                    this.connection.disconnect();
                    this.connection.connect();
                    this.connection.login(this.user, this.password);
                }
                throw ex;
            }
        }
    }

    @Override
    public void start() {
        assert (this.messageHandler != null) : new NullPointerException("MessageHandler not specified.");
        this.connection = new XMPPConnection(this.config);
        try {
            this.connection.connect();
            this.connection.addConnectionListener((ConnectionListener)new MyConnectionListener());
            this.fileTransfer = new FileTransferManager(this.connection);
            this.fileTransfer.addFileTransferListener((FileTransferListener)new BigMessageTransferListener());
            this.initPacketListener();
            this.login();
            if (this.roomId != null && this.roomId.trim().length() > 0) {
                this.initRoomConnectivity();
            }
            if (this.room != null) {
                this.room.join(this.user);
            }
            if (!this.ignoreRoster) {
                Roster roster = this.connection.getRoster();
                Presence presence = new Presence(Presence.Type.subscribe);
                for (RosterEntry entry : roster.getEntries()) {
                    presence.setTo(entry.getUser());
                    this.connection.sendPacket((Packet)presence);
                }
            }
        }
        catch (XMPPException e) {
            if (this.connection != null && this.connection.isConnected()) {
                this.connection.disconnect();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isConnected() {
        return this.connection != null && this.connection.isConnected();
    }

    @Override
    public void stop() {
        if (this.connection != null) {
            try {
                this.connection.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public PeerRelatedActivityFactory newSendActivityFactory() {
        return new PeerRelatedActivityFactory(){

            @Override
            public PeerRelatedActivity createActivity() {
                return new PeerRelatedActivity(){

                    @Override
                    public Boolean call() throws Exception {
                        Message msg = this.getMessage();
                        if (Structs.getPart(msg, "reply-to") == null) {
                            Structs.combine(msg, Structs.struct("reply-to", XMPPPeerInterface.this.connection.getUser()));
                        }
                        Protocol protocol = new Protocol();
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        protocol.writeMessage(out, msg);
                        byte[] data = out.toByteArray();
                        if (data.length > XMPPPeerInterface.this.fileTransferThreshold) {
                            OutgoingFileTransfer outFile = XMPPPeerInterface.this.fileTransfer.createOutgoingFileTransfer((String)this.getTarget());
                            outFile.sendStream((InputStream)new ByteArrayInputStream(data), "", (long)data.length, "");
                            return true;
                        }
                        try {
                            org.jivesoftware.smack.packet.Message xmpp = new org.jivesoftware.smack.packet.Message((String)this.getTarget());
                            xmpp.setBody(StringUtils.encodeBase64((byte[])out.toByteArray()));
                            xmpp.setProperty("hypergraphdb", (Object)Boolean.TRUE);
                            XMPPPeerInterface.this.connection.sendPacket((Packet)xmpp);
                            return true;
                        }
                        catch (Throwable t) {
                            t.printStackTrace(System.err);
                            return false;
                        }
                    }
                };
            }
        };
    }

    @Override
    public Future<Boolean> send(Object networkTarget, Message msg) {
        PeerRelatedActivityFactory activityFactory = this.newSendActivityFactory();
        PeerRelatedActivity act = activityFactory.createActivity();
        act.setTarget(networkTarget);
        act.setMessage(msg);
        if (this.thisPeer != null) {
            return this.thisPeer.getExecutorService().submit(act);
        }
        try {
            return new CompletedFuture<Boolean>((Boolean)act.call());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void broadcast(Message msg) {
        for (HGPeerIdentity peer : this.thisPeer.getConnectedPeers()) {
            this.send(this.thisPeer.getNetworkTarget(peer), msg);
        }
    }

    @Override
    public HyperGraphPeer getThisPeer() {
        return this.thisPeer;
    }

    @Override
    public PeerFilter newFilterActivity(PeerFilterEvaluator evaluator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addPeerPresenceListener(NetworkPeerPresenceListener listener) {
        this.presenceListeners.add(listener);
    }

    @Override
    public void removePeerPresenceListener(NetworkPeerPresenceListener listener) {
        this.presenceListeners.remove(listener);
    }

    @Override
    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    @Override
    public void setThisPeer(HyperGraphPeer thisPeer) {
        this.thisPeer = thisPeer;
    }

    public XMPPConnection getConnection() {
        return this.connection;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public Number getPort() {
        return this.port;
    }

    public void setPort(Number port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public boolean isAutoRegister() {
        return this.autoRegister;
    }

    public void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    public int getFileTransferThreshold() {
        return this.fileTransferThreshold;
    }

    public void setFileTransferThreshold(int fileTransferThreshold) {
        this.fileTransferThreshold = fileTransferThreshold;
    }

    private class MyConnectionListener
    implements ConnectionListener {
        private MyConnectionListener() {
        }

        public void connectionClosed() {
        }

        public void connectionClosedOnError(Exception ex) {
            ex.printStackTrace(System.err);
            XMPPPeerInterface.this.reconnect();
        }

        public void reconnectingIn(int arg0) {
        }

        public void reconnectionFailed(Exception ex) {
            ex.printStackTrace(System.err);
            XMPPPeerInterface.this.reconnect();
        }

        public void reconnectionSuccessful() {
        }
    }

    private class BigMessageTransferListener
    implements FileTransferListener {
        private BigMessageTransferListener() {
        }

        public void fileTransferRequest(FileTransferRequest request) {
            if (XMPPPeerInterface.this.thisPeer.getIdentity(request.getRequestor()) != null) {
                IncomingFileTransfer inFile = request.accept();
                Message M = null;
                InputStream in = null;
                XMPPPeerInterface.this.thisPeer.getGraph().getTransactionManager().beginTransaction();
                try {
                    in = inFile.recieveFile();
                    if (inFile.getFileSize() > Integer.MAX_VALUE) {
                        throw new Exception("Message from " + request.getRequestor() + " to long with " + inFile.getFileSize() + " bytes.");
                    }
                    byte[] B = new byte[(int)inFile.getFileSize()];
                    int count = 0;
                    while ((long)count < inFile.getFileSize()) {
                        count += in.read(B, count, (int)inFile.getFileSize() - count);
                    }
                    M = new Message(new Protocol().readMessage(new ByteArrayInputStream(B)));
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                    throw new RuntimeException(t);
                }
                finally {
                    try {
                        XMPPPeerInterface.this.thisPeer.getGraph().getTransactionManager().endTransaction(false);
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.err);
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.err);
                    }
                }
                XMPPPeerInterface.this.messageHandler.handleMessage(M);
            } else {
                request.reject();
            }
        }
    }
}

