/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.workflow;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hypergraphdb.peer.workflow.Activity;
import org.hypergraphdb.peer.workflow.Transition;
import org.hypergraphdb.peer.workflow.WorkflowStateConstant;

public class TransitionMap {
    private Map<String, Set<Transition>> map = Collections.synchronizedMap(new HashMap());
    private Map<Transition, Set<String>> inverseMap = Collections.synchronizedMap(new HashMap());
    private Map<String, Transition> activityMap = Collections.synchronizedMap(new HashMap());

    public Transition getTransition(WorkflowStateConstant fromState, Map<String, ? extends Object> messageAttributes) {
        HashSet<Transition> candidates = null;
        HashSet<String> foundKeys = null;
        for (Map.Entry<String, ? extends Object> e : messageAttributes.entrySet()) {
            String key = fromState.toString() + "&" + e.getKey() + "=" + e.getValue();
            Set<Transition> S = this.map.get(key);
            if (S == null) continue;
            if (candidates == null) {
                candidates = new HashSet<Transition>();
                candidates.addAll(S);
                foundKeys = new HashSet<String>();
            } else {
                for (Transition t : candidates) {
                    if (S.contains(t)) continue;
                    candidates.remove(t);
                }
            }
            foundKeys.add(key);
        }
        if (candidates == null) {
            return null;
        }
        switch (candidates.size()) {
            case 1: {
                return (Transition)candidates.iterator().next();
            }
            case 0: {
                throw new RuntimeException("Ambiguous transition for message attributes " + messageAttributes);
            }
        }
        Transition result = null;
        for (Transition can : candidates) {
            if (!((Object)this.inverseMap.get(can)).equals(foundKeys)) continue;
            if (result == null) {
                result = can;
                continue;
            }
            throw new RuntimeException("Ambiguous transition for message attributes " + messageAttributes);
        }
        if (result == null) {
            throw new RuntimeException("Ambiguous transition for message attributes " + messageAttributes);
        }
        return result;
    }

    public void setTransition(WorkflowStateConstant fromState, Map<String, String> messageAttributes, Transition transition) {
        if (messageAttributes == null || messageAttributes.isEmpty()) {
            throw new IllegalArgumentException("At least some message attributes should be specified for a state transition.");
        }
        HashSet<String> inverseSet = new HashSet<String>();
        for (Map.Entry<String, String> e : messageAttributes.entrySet()) {
            String key = fromState.toString() + "&" + e.getKey() + "=" + e.getValue();
            Set<Transition> S = this.map.get(key);
            if (S == null) {
                S = new HashSet<Transition>();
                this.map.put(key, S);
            }
            S.add(transition);
            inverseSet.add(key);
        }
        this.inverseMap.put(transition, inverseSet);
    }

    public Transition getTransition(WorkflowStateConstant fromState, Activity fromActivity, WorkflowStateConstant atActivityState) {
        String key = fromState.toString() + "&" + fromActivity.getType() + "&" + atActivityState.toString();
        return this.activityMap.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransition(WorkflowStateConstant fromState, String subActivityType, WorkflowStateConstant atSubActivityState, Transition t) {
        Map<String, Transition> map = this.activityMap;
        synchronized (map) {
            String key = fromState.toString() + "&" + subActivityType + "&" + atSubActivityState.toString();
            Transition existing = this.activityMap.get(key);
            if (existing != null) {
                throw new RuntimeException("A transition alread exist from state " + fromState + " and sub-activity " + subActivityType + " at state " + atSubActivityState);
            }
            this.activityMap.put(key, t);
        }
    }
}

