/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.workflow;

import java.util.ArrayList;
import java.util.UUID;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.peer.HyperGraphPeer;
import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.Messages;
import org.hypergraphdb.peer.Structs;
import org.hypergraphdb.peer.workflow.Activity;
import org.hypergraphdb.query.HGQueryCondition;
import org.hypergraphdb.storage.StorageGraph;

public class QueryTaskServer
extends Activity {
    public QueryTaskServer(HyperGraphPeer thisPeer, UUID id) {
        super(thisPeer, id);
    }

    @Override
    public void initiate() {
    }

    @Override
    public void handleMessage(Message msg) {
        boolean getObject = (Boolean)Structs.getPart(msg, "content", "getObj");
        Object query = Structs.getPart(msg, "content", "query");
        Message reply = Messages.getReply(msg);
        if (query instanceof HGHandle) {
            StorageGraph subgraph = this.getThisPeer().getSubgraph((HGHandle)query);
            Structs.combine(reply, Structs.struct("content", Structs.list(Structs.object(subgraph))));
        } else if (query instanceof HGQueryCondition) {
            HGSearchResult results = this.getThisPeer().getGraph().find((HGQueryCondition)query);
            ArrayList<Object> resultingContent = new ArrayList<Object>();
            while (results.hasNext()) {
                HGHandle handle = (HGHandle)results.next();
                if (getObject) {
                    resultingContent.add(Structs.object(this.getThisPeer().getSubgraph(handle)));
                    continue;
                }
                resultingContent.add(this.getThisPeer().getGraph().getPersistentHandle(handle));
            }
            Structs.combine(reply, Structs.struct("content", resultingContent));
        } else {
            Structs.combine(reply, Structs.struct("content", null));
        }
        this.getPeerInterface().send(Messages.getSender(msg), reply);
    }
}

