/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.workflow;

import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.Performative;
import org.hypergraphdb.peer.Structs;
import org.hypergraphdb.peer.workflow.Conversation;
import org.hypergraphdb.peer.workflow.TaskActivity;

public class ProposalConversation
extends Conversation<State> {
    public ProposalConversation(TaskActivity<?> task, Object peer) {
        super(task, peer, State.Started, State.Done);
        this.registerPerformativeTransition(State.Proposed, Performative.AcceptProposal, State.Accepted);
        this.registerPerformativeTransition(State.Started, Performative.Propose, State.Proposed);
        this.registerPerformativeTransition(State.Accepted, Performative.Confirm, State.Confirmed);
        this.registerPerformativeTransition(State.Accepted, Performative.Disconfirm, State.Disconfirmed);
    }

    public boolean propose(Message msg) {
        if (this.compareAndSetState(State.Started, State.Proposed)) {
            Structs.combine(msg, Structs.struct("performative", Performative.Propose));
            this.say(msg);
            return true;
        }
        return false;
    }

    public boolean accept(Message msg) {
        if (this.compareAndSetState(State.Proposed, State.Accepted)) {
            Structs.combine(msg, Structs.struct("performative", Performative.AcceptProposal));
            this.say(msg);
            return true;
        }
        return false;
    }

    public void reject(Object msg) {
        if (this.compareAndSetState(State.Proposed, State.Rejected)) {
            // empty if block
        }
    }

    public boolean confirm(Message msg) {
        System.out.println("ProposalConversation: confirm");
        if (this.compareAndSetState(State.Accepted, State.Confirmed)) {
            Structs.combine(msg, Structs.struct("performative", Performative.Confirm));
            this.say(msg);
            return true;
        }
        return false;
    }

    public void disconfirm(Object msg) {
        if (this.compareAndSetState(State.Accepted, State.Disconfirmed)) {
            // empty if block
        }
    }

    public static enum State {
        Started,
        Proposed,
        Accepted,
        Rejected,
        Confirmed,
        Disconfirmed,
        Done;

    }
}

