/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.workflow;

import java.lang.reflect.Constructor;
import java.util.UUID;
import org.hypergraphdb.peer.HyperGraphPeer;
import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.workflow.Activity;
import org.hypergraphdb.peer.workflow.ActivityFactory;

public class DefaultActivityFactory
implements ActivityFactory {
    private Class<? extends Activity> activityClass;
    private Constructor<? extends Activity> constructor = null;

    public DefaultActivityFactory(Class<? extends Activity> activityClass) {
        this.activityClass = activityClass;
        try {
            this.constructor = activityClass.getConstructor(HyperGraphPeer.class, UUID.class, Message.class);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (this.constructor == null) {
            try {
                this.constructor = activityClass.getConstructor(HyperGraphPeer.class, UUID.class);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        if (this.constructor == null) {
            try {
                this.constructor = activityClass.getConstructor(HyperGraphPeer.class);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        if (this.constructor == null) {
            try {
                this.constructor = activityClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException("Can't find appropriate constructor for class " + activityClass.getName());
            }
        }
    }

    @Override
    public Activity make(HyperGraphPeer thisPeer, UUID id, Message msg) {
        try {
            if (this.constructor.getParameterTypes().length == 0) {
                return this.constructor.newInstance(new Object[0]);
            }
            if (this.constructor.getParameterTypes().length == 1) {
                return this.constructor.newInstance(thisPeer);
            }
            if (this.constructor.getParameterTypes().length == 2) {
                return this.constructor.newInstance(thisPeer, id);
            }
            return this.constructor.newInstance(thisPeer, id, msg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getActivityClass() {
        return this.activityClass;
    }
}

