/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.workflow;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.hypergraphdb.peer.HyperGraphPeer;
import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.MessageHandler;
import org.hypergraphdb.peer.Messages;
import org.hypergraphdb.peer.Performative;
import org.hypergraphdb.peer.PerformativeConstant;
import org.hypergraphdb.peer.Structs;
import org.hypergraphdb.peer.workflow.Activity;
import org.hypergraphdb.peer.workflow.ActivityFactory;
import org.hypergraphdb.peer.workflow.ActivityListener;
import org.hypergraphdb.peer.workflow.ActivityResult;
import org.hypergraphdb.peer.workflow.ActivityType;
import org.hypergraphdb.peer.workflow.AtActivity;
import org.hypergraphdb.peer.workflow.DefaultActivityFactory;
import org.hypergraphdb.peer.workflow.FSMActivity;
import org.hypergraphdb.peer.workflow.FromState;
import org.hypergraphdb.peer.workflow.MethodCallTransition;
import org.hypergraphdb.peer.workflow.OnActivityState;
import org.hypergraphdb.peer.workflow.OnMessage;
import org.hypergraphdb.peer.workflow.StateListener;
import org.hypergraphdb.peer.workflow.Transition;
import org.hypergraphdb.peer.workflow.TransitionMap;
import org.hypergraphdb.peer.workflow.WorkflowState;
import org.hypergraphdb.peer.workflow.WorkflowStateConstant;
import org.hypergraphdb.util.HGUtils;

public class ActivityManager
implements MessageHandler {
    private HyperGraphPeer thisPeer;
    private Map<String, ActivityType> activityTypes = Collections.synchronizedMap(new HashMap());
    private Map<UUID, Activity> activities = Collections.synchronizedMap(new HashMap());
    private Map<Activity, Activity> parents = Collections.synchronizedMap(new HashMap());
    final BlockingQueue<Activity> globalQueue = new PriorityBlockingQueue<Activity>(10, new Comparator<Activity>(){

        @Override
        public int compare(Activity left, Activity right) {
            long st;
            long diff;
            if (left.future.isWaitedOn()) {
                if (!right.future.isWaitedOn() && !left.queue.isEmpty()) {
                    return -1;
                }
            } else if (right.future.isWaitedOn() && !right.queue.isEmpty()) {
                return 1;
            }
            return (diff = ((st = System.currentTimeMillis()) - right.lastActionTimestamp) * (long)(1 + right.queue.size()) - (st - left.lastActionTimestamp) * (long)(1 + left.queue.size())) > 0L ? 1 : (diff < 0L ? -1 : 0);
        }
    });
    private ActivitySchedulingThread schedulerThread = null;

    private void handleActivityException(Activity activity, Throwable exception, Message msg) {
        activity.future.result.exception = exception;
        activity.getState().assign(WorkflowState.Failed);
        exception.printStackTrace(System.err);
        if (msg != null) {
            this.thisPeer.getPeerInterface().send(Messages.getSender(msg), Messages.getReply(msg, Performative.Failure, HGUtils.printStackTrace(exception)));
        }
    }

    private Activity findRootActivity(Activity a) {
        Activity root = a;
        Activity tmp = this.parents.get(root);
        while (tmp != null) {
            root = tmp;
            tmp = this.parents.get(root);
        }
        return root;
    }

    private void notUnderstood(Message msg, String exlanation) {
        try {
            Map<String, Object> reply = Structs.combine(Messages.getReply(msg), Structs.struct("performative", Performative.NotUnderstood, "content", msg));
            this.thisPeer.getPeerInterface().send(Messages.getSender(msg), (Message)reply);
            System.out.println("Sending not understood on " + msg + " because " + exlanation);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    private Runnable makeTransitionAction(final ActivityType type, final Activity parentActivity, final Activity activity) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Activity rootActivity = ActivityManager.this.findRootActivity(parentActivity);
                try {
                    Transition transition = type.getTransitionMap().getTransition(parentActivity.getState().getConst(), activity, activity.getState().getConst());
                    if (transition == null) {
                        return;
                    }
                    WorkflowStateConstant result = transition.apply(parentActivity, activity);
                    if (result != null) {
                        parentActivity.getState().assign(result);
                    }
                }
                catch (Throwable t) {
                    ActivityManager.this.handleActivityException(parentActivity, t, null);
                }
                finally {
                    parentActivity.lastActionTimestamp = System.currentTimeMillis();
                    try {
                        ActivityManager.this.globalQueue.put(rootActivity);
                    }
                    catch (InterruptedException ex) {
                        ActivityManager.this.handleActivityException(rootActivity, ex, null);
                    }
                }
            }
        };
    }

    private Runnable makeTransitionAction(final ActivityType type, final FSMActivity activity, final Message msg) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Activity rootActivity = ActivityManager.this.findRootActivity(activity);
                try {
                    Transition transition = type.getTransitionMap().getTransition(activity.getState().getConst(), msg);
                    if (transition == null) {
                        PerformativeConstant perf = Performative.toConstant((String)Structs.getPart(msg, "performative"));
                        if (perf == Performative.Failure) {
                            activity.onPeerFailure(msg);
                        } else if (perf == Performative.NotUnderstood) {
                            activity.onPeerNotUnderstand(msg);
                        } else {
                            ActivityManager.this.notUnderstood(msg, " no state transition defined for this performative.");
                        }
                    } else {
                        Thread.currentThread().setContextClassLoader(ActivityManager.this.thisPeer.getGraph().getTypeSystem().getClassLoader());
                        WorkflowStateConstant result = transition.apply(activity, msg);
                        if (result != null) {
                            activity.getState().assign(result);
                        }
                    }
                }
                catch (Throwable t) {
                    ActivityManager.this.handleActivityException(activity, t, msg);
                }
                finally {
                    activity.lastActionTimestamp = System.currentTimeMillis();
                    try {
                        if (!rootActivity.getState().isFinished()) {
                            ActivityManager.this.globalQueue.put(rootActivity);
                        }
                    }
                    catch (InterruptedException ex) {
                        ActivityManager.this.handleActivityException(rootActivity, ex, null);
                    }
                }
            }
        };
    }

    private Runnable makeMessageHandleAction(final Activity activity, final Message msg) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Activity rootActivity = ActivityManager.this.findRootActivity(activity);
                try {
                    activity.handleMessage(msg);
                }
                catch (Throwable t) {
                    ActivityManager.this.handleActivityException(activity, t, msg);
                }
                finally {
                    activity.lastActionTimestamp = System.currentTimeMillis();
                    try {
                        if (!rootActivity.getState().isFinished()) {
                            ActivityManager.this.globalQueue.put(rootActivity);
                        }
                    }
                    catch (InterruptedException ex) {
                        ActivityManager.this.handleActivityException(rootActivity, ex, null);
                    }
                }
            }
        };
    }

    private void readTransitionMap(Class<? extends Activity> activityClass, TransitionMap map) {
        for (Method m : activityClass.getMethods()) {
            FromState aFromState = m.getAnnotation(FromState.class);
            OnMessage onMessage = m.getAnnotation(OnMessage.class);
            AtActivity atActivity = m.getAnnotation(AtActivity.class);
            OnActivityState onState = m.getAnnotation(OnActivityState.class);
            if (atActivity != null && onState == null || onState != null && atActivity == null) {
                throw new RuntimeException("Both OnStateActivity and AtActivity annotations need to be specified for method " + m + " in class " + activityClass.getName() + " or neither.");
            }
            if (aFromState == null) {
                if (onMessage == null && atActivity == null && onState == null) continue;
                throw new RuntimeException("A transition method needs to be annotated with  with a FromState annotation.");
            }
            if (onMessage == null && atActivity == null) {
                throw new RuntimeException("A transition method needs to be annotated either  with an OnMessage or both AtActivity and OnActivityState annotations.");
            }
            HashMap<String, String> msgAttrs = null;
            if (onMessage != null) {
                msgAttrs = new HashMap<String, String>();
                msgAttrs.put("performative", onMessage.performative());
            }
            MethodCallTransition t = new MethodCallTransition(m);
            for (String from : aFromState.value()) {
                WorkflowStateConstant fromState = WorkflowState.toStateConstant(from);
                if (msgAttrs != null) {
                    map.setTransition(fromState, msgAttrs, t);
                }
                if (atActivity == null) continue;
                for (String to : onState.value()) {
                    map.setTransition(fromState, atActivity.value(), WorkflowState.toStateConstant(to), t);
                }
            }
        }
    }

    public ActivityManager(HyperGraphPeer thisPeer) {
        this.thisPeer = thisPeer;
    }

    public void start() {
        this.schedulerThread = new ActivitySchedulingThread();
        this.schedulerThread.setContextClassLoader(this.thisPeer.getGraph().getTypeSystem().getClassLoader());
        this.schedulerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.schedulerThread == null) {
            return;
        }
        this.schedulerThread.schedulerRunning = false;
        try {
            if (this.schedulerThread.isAlive()) {
                this.schedulerThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.schedulerThread = null;
        }
    }

    public void clear() {
        this.activities.clear();
        this.activityTypes.clear();
        this.parents.clear();
        this.globalQueue.clear();
    }

    public void clearActivities() {
        this.activities.clear();
        this.parents.clear();
        this.globalQueue.clear();
    }

    public Activity getActivity(UUID id) {
        return this.activities.get(id);
    }

    public void registerActivityType(Class<? extends Activity> activityClass) {
        this.registerActivityType(activityClass.getName(), activityClass, new DefaultActivityFactory(activityClass));
    }

    public void registerActivityType(Class<? extends Activity> activityClass, ActivityFactory factory) {
        this.registerActivityType(activityClass.getName(), activityClass, factory);
    }

    public void registerActivityType(String type, Class<? extends Activity> activityClass) {
        this.registerActivityType(type, activityClass, new DefaultActivityFactory(activityClass));
    }

    public void registerActivityType(String type, Class<? extends Activity> activityClass, ActivityFactory factory) {
        if (this.activityTypes.containsKey(type)) {
            throw new IllegalArgumentException("Activity type '" + type + "' already registered.");
        }
        ActivityType activityType = new ActivityType(type, factory);
        this.readTransitionMap(activityClass, activityType.getTransitionMap());
        this.activityTypes.put(type, activityType);
    }

    public Future<ActivityResult> initiateActivity(Activity activity) {
        return this.initiateActivity(activity, null, null);
    }

    public Future<ActivityResult> initiateActivity(Activity activity, ActivityListener listener) {
        return this.initiateActivity(activity, null, listener);
    }

    public Future<ActivityResult> initiateActivity(Activity activity, Activity parentActivity, ActivityListener listener) {
        ActivityFuture future = this.insertNewActivity(activity, parentActivity, listener);
        activity.getState().compareAndAssign(WorkflowState.Limbo, WorkflowState.Started);
        activity.initiate();
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActivityFuture insertNewActivity(final Activity activity, final Activity parentActivity, final ActivityListener listener) {
        ActivityFuture future;
        Map<UUID, Activity> map = this.activities;
        synchronized (map) {
            if (this.activities.containsKey(activity.getId())) {
                throw new RuntimeException("Activity " + activity + " with ID " + activity.getId() + " has already been initiated.");
            }
            this.activities.put(activity.getId(), activity);
        }
        final CountDownLatch completionLatch = new CountDownLatch(1);
        activity.future = future = new ActivityFuture(activity, completionLatch);
        activity.getState().addListener(new StateListener(){

            @Override
            public void stateChanged(WorkflowState state) {
                if (state.isFinished()) {
                    completionLatch.countDown();
                    if (listener != null) {
                        try {
                            listener.activityFinished(future.get());
                        }
                        catch (Throwable t) {
                            t.printStackTrace(System.err);
                        }
                    }
                    ActivityManager.this.globalQueue.remove(activity);
                    ActivityManager.this.activities.remove(activity.getId());
                    ActivityManager.this.parents.remove(activity);
                }
            }
        });
        if (parentActivity != null) {
            activity.queue = parentActivity.queue;
            this.parents.put(activity, parentActivity);
            activity.getState().addListener(new StateListener(){

                @Override
                public void stateChanged(WorkflowState state) {
                    ActivityType pt = (ActivityType)ActivityManager.this.activityTypes.get(parentActivity.getType());
                    parentActivity.queue.add(ActivityManager.this.makeTransitionAction(pt, parentActivity, activity));
                }
            });
        } else {
            try {
                this.globalQueue.put(activity);
            }
            catch (InterruptedException ex) {
                this.handleActivityException(activity, ex, null);
            }
        }
        return future;
    }

    @Override
    public void handleMessage(Message msg) {
        UUID activityId = (UUID)Structs.getPart(msg, "conversation-id");
        if (activityId == null) {
            this.notUnderstood(msg, " missing conversation-id in message");
            return;
        }
        Activity activity = this.activities.get(activityId);
        ActivityType type = null;
        if (activity == null) {
            Activity parentActivity = null;
            UUID parentId = (UUID)Structs.getPart(msg, "x-parent-scope");
            if (parentId != null && (parentActivity = this.activities.get(parentId)) == null) {
                this.notUnderstood(msg, " unkown parent activity " + parentId);
                return;
            }
            type = this.activityTypes.get(Structs.getPart(msg, "x-activity-type"));
            if (type == null) {
                this.notUnderstood(msg, " unkown activity type '" + type + "'");
                return;
            }
            activity = type.getFactory().make(this.thisPeer, activityId, msg);
            this.insertNewActivity(activity, parentActivity, null);
            System.out.println("inserted new activity in queue " + activity.getId());
            activity.getState().compareAndAssign(WorkflowState.Limbo, WorkflowState.Started);
        } else {
            type = this.activityTypes.get(activity.getType());
        }
        try {
            if (activity instanceof FSMActivity) {
                activity.queue.put(this.makeTransitionAction(type, (FSMActivity)activity, msg));
            } else {
                activity.queue.put(this.makeMessageHandleAction(activity, msg));
            }
        }
        catch (InterruptedException ex) {
            this.handleActivityException(activity, ex, msg);
        }
    }

    public Activity getParent(Activity a) {
        return this.parents.get(a);
    }

    class ActivityFuture
    implements Future<ActivityResult> {
        ActivityResult result;
        CountDownLatch latch;
        AtomicInteger waiting = new AtomicInteger(0);

        boolean isWaitedOn() {
            return this.waiting.get() > 0;
        }

        public ActivityFuture(Activity activity, CountDownLatch latch) {
            this.result = new ActivityResult(activity);
            this.latch = latch;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ActivityResult get() throws InterruptedException, ExecutionException {
            this.waiting.incrementAndGet();
            try {
                this.latch.await();
            }
            catch (InterruptedException ex) {
                this.waiting.decrementAndGet();
                throw ex;
            }
            return this.result;
        }

        @Override
        public ActivityResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.waiting.incrementAndGet();
            try {
                if (!this.latch.await(timeout, unit)) {
                    this.waiting.decrementAndGet();
                    return null;
                }
                return this.result;
            }
            catch (InterruptedException ex) {
                this.waiting.decrementAndGet();
                throw ex;
            }
        }

        @Override
        public boolean isCancelled() {
            return this.result.getActivity().getState().isCanceled();
        }

        @Override
        public boolean isDone() {
            return this.result.getActivity().getState().isFinished();
        }
    }

    private class ActivitySchedulingThread
    extends Thread {
        volatile boolean schedulerRunning;

        public ActivitySchedulingThread() {
            super("HGDB Peer Scheduler");
            this.schedulerRunning = false;
        }

        @Override
        public void run() {
            int reportEmpty = 0;
            this.schedulerRunning = true;
            while (this.schedulerRunning) {
                try {
                    Activity a = ActivityManager.this.globalQueue.poll(1L, TimeUnit.SECONDS);
                    if (a == null) {
                        if (reportEmpty >= 50) {
                            reportEmpty = 0;
                        }
                        ++reportEmpty;
                        continue;
                    }
                    if (!a.queue.isEmpty() && !a.getState().isFinished()) {
                        Runnable r = a.queue.take();
                        ActivityManager.this.thisPeer.getExecutorService().execute(r);
                        continue;
                    }
                    if (ActivityManager.this.globalQueue.isEmpty()) {
                        Thread.sleep(100L);
                    }
                    a.lastActionTimestamp = System.currentTimeMillis();
                    if (a.getState().isFinished()) continue;
                    ActivityManager.this.globalQueue.put(a);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                    break;
                }
            }
            this.schedulerRunning = false;
        }
    }
}

